/************************************************************************
 * Copyright (c) 2006 - 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: BaseProfiler.h,v 1.6 2009/05/20 03:35:01 kchan Exp $ 
 ************************************************************************/

#ifndef _BASE_PROFILER_H_
#define _BASE_PROFILER_H_

#include "MpiAPI.h"
#include "OSA.h"
#include "MRTEResults.h"
#include "VMInitEvent.h"
#include "VMShutdownEvent.h"
#include "StartEvent.h"
#include "StopEvent.h"
#include "AttachEvent.h"
#include "DetachEvent.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace BaseProf {

    class CBaseProfiler
    {
    public:
        // Constructor
        CBaseProfiler();
        // Destructor
        virtual ~CBaseProfiler();
        // Initialization
		TResult Init(MPI::IMpi *pMpiApi, MPI::TId clientId, const char *szOptions);

    protected:
        // Function must be implemented in overloading profiler. 
        // Profiler specific events should be initialised in this function
        virtual TResult InitProfilerSpecificEvents() = 0;
        // Function must be implemented in overloading profiler. 
        // Profiler specific filter should be initialised in this function
        virtual TResult InitFilter() = 0;
        // Function must be implemented in overloading profiler. 
        // Profiler specific options should be parsed in this function
        virtual TResult ParceOptions(const char *szOptions) = 0;
        // Profiler name
        char* m_profilerName;
        // profiler env object
        CProfEnv m_pProfEnv;
    private:
        // Initializes internal data and registers for VM shutdown event
        TResult InitEvents();
        // VM init event object
        CVMInitEvent        m_VMInitHandler;
        // VM shutdown event object
        CVMShutdownEvent    m_VMShutdownHandler;
        // Start event object
        CECStartEvent       m_startHandler;
        // Stop event object
        CECStopEvent        m_stopHandler;
        // Attach event object
        CECAttachEvent      m_attachHandler;
        // Detach event object
        CECDetachEvent      m_detachHandler;

    };

} /*namespace Martini*/  } /*namespace BaseProf*/

#endif // _BASE_PROFILER_H_
