/************************************************************************
 * Copyright (c) 2006, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: DetachEvent.cpp,v 1.7 2009/05/20 03:35:01 kchan Exp $ 
 ************************************************************************/

#include "DetachEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::MPI;

CECDetachEvent::CECDetachEvent(){}
CECDetachEvent::~CECDetachEvent(){}

/*
 * Init - initializes internal data and registers for Detach event    
 */
TResult 
CECDetachEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult res = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return res;
}

/*
 * HandleEvent - callback function for Detach event    
 */
void 
CECDetachEvent::HandleEvent()
{
    if (!m_pProfEnv->m_bVMInitDone) {
        return;
    }
    // Modify for bug 194081
    // m_pProfEnv->ec_env->SetProfileOption("EXECDETAILS", "false");
    m_pProfEnv->m_pShadowStackTracker->TrackECDetach();
    // Modify for bug 194081
    if (!m_pProfEnv->IsSupportedEG(EG_CALL_GRAPH) && !m_pProfEnv->IsSupportedEG(EG_HEAP)) {
        return;
    }
    TResult res = m_pProfEnv->DisableSupportedEG();
    if (MRTE_FAILED(res)) {
        if (MRTE_ERROR_PHASE_FAILURE == res) {
            LOG_DIE("Detach failed (too early)");
        } else {
            LOG_DIE("Detach failed");
        }
    }
}
