/************************************************************************
 * Copyright (c) 2006, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ProfEnv.h,v 1.30 2010/05/05 01:47:51 jwest Exp $ 
 ************************************************************************/

#ifndef _PROF_ENV_H_
#define _PROF_ENV_H_

// Add for bug 194081
#include <stack>
#include <map>
// Add for bug 194081

#include <vector>

#include "MpiAPI.h"
#include "OSA.h"

// Add for bug 241984 and bug 226572
// old code can just work on Windows but not on Linux for these bugs
#include "LibraryLoader.h"
// Add for bug 241984 and bug 226572

#include "EC_Env.h"
#include "TIdSet.h"
#include "Tickets.h"
#include "InStructs.h"

namespace Martini { namespace BaseProf {

    enum EventType {CONTENDED_MONITOR_ENTERED_EVENT, CONTENDED_MONITOR_ENTER_EVENT, 
        MONITOR_WAITED_EVENT, MONITOR_WAIT_EVENT, THREAD_START_EVENT, THREAD_END_EVENT,
        THREAD_INTERACTION};

    struct SThreadEventsData {
        EventType type;
        MPI::TId threadId;
        union SStructs {
            MPI::SContendedMonitorEnteredEventData cedData;
            MPI::SContendedMonitorEnterEventData cerData;
            MPI::SMonitorWaitedEventData wedData;
            MPI::SMonitorWaitEventData wetData;
            MPI::SThreadEventData tevData;
//            MPI::SThreadInfo tinData;
        } data;
        U64 timeout;
        bool isNewThread;
        MPI::SThreadInfo threadInfo; //For THREAD_START_EVENT only
        MPI::TId objectId; //For THREAD_START_EVENT only
    };
    
    // Add for bug 194081
    class CCGShadowStackTracker
    {
        class CVMStackTrackData
        {
        public:
            MPI::TId threadId;
            std::stack< MPI::TId > shadowStack;
            std::stack< MPI::TId > normalStack;
        };

    public:
    	CCGShadowStackTracker(CProfEnv& profEnv);
    	~CCGShadowStackTracker();

        // Assure init process is successful, called by CProfEnv init
    	bool ValidateCGShadowStackTracker();
    	
    	//---------------------------------------------------------------------
        // Common profiler events need to be tracked, except for VMInit, ECStart and ECStop event
    	void TrackVMShutdown();

    	void TrackECAttach();
    	void TrackECDetach();
    	
    	//---------------------------------------------------------------------
    	// Call Graph profiler specialized events, except for NewMethod and ThreadStart
        void TrackMethodEnter(MPI::SMethodEnterEventData& data);
        
        // TrackMethodLeave return bool to avoid handle MethodLeave events before reattach
        bool TrackMethodLeave(MPI::SMethodLeaveEventData& data);
        
        void TrackThreadEnd(MPI::SThreadEventData &data);

    private:
        // Functions for deciding whether to track corresponding events 
        bool isNeedTrack();
        
        // Used by ECAttach tracker
        TResult InitNewThreadInfoArray(MPI::SThreadInfoArray& threadInfoArray, 
            int MAX_THREADS, int MAX_FRAMES);
        void DestroyThreadInfoArray(MPI::SThreadInfoArray& threadInfoArray);
        
        TResult GetInitialShadowStackTraces(MPI::SThreadInfoArray& threadInfoArray);
        void ReportThreadsStart(MPI::SThreadInfoArray& threadInfoArray);  // Refer to CGProf ThreadStartHandler
        
        void ReportMethodEnter(MPI::TId threadId, MPI::SThreadInfo* pThreadInfo, MPI::TId methodId);
        void ReportMethodsEnter(MPI::SThreadInfoArray& threadInfoArray);
        
        void SaveAllShadowStacksMethods(MPI::SThreadInfoArray& threadInfoArray);
        
        // Used by MethodEnter and ThreadEnd trackers, ReportLeftStackTrackDataMethodsLeave
        void ReportMethodLeave(MPI::TId threadId, MPI::TId methodId, MPI::TTimeStamp uiCpuNanos);
        
        // Used by MethodEnter tracker 
        void UpdateShadowStack(std::stack< MPI::TId >&, std::stack< MPI::TId >&, 
            const MPI::SMethodEnterEventData&);
            
        // Used by VMShutdown and Detach trackers
        // Generate method leave events for each left methods in track stack
        void ReportLeftStackTrackDataMethodsLeave();

        // Get Thread CPU time wrapper function
        MPI::TTimeStamp GetThreadCPUTime(MPI::TId threadId);

    private:
    	CProfEnv& m_refProfEnv;

        OSA::IThreadSync* m_lockVMStackDataMap;
        std::map< MPI::TId, CVMStackTrackData > m_VMStacktraceDataMap;
    };
    // Add for bug 194081

    class CProfEnv
    {
    public:
        // Constructor
        CProfEnv();
        // Destructor
        ~CProfEnv();
        // Initializes internal data and registers
        TResult Init(const char* libName);
        //
        void Flush();
        //
        //void AddNewClassData(MPI::TId classId, MPI::SClassInfo* pSClassInfo);
        void AddNewClassData(MPI::TId classId, MPI::SClassInfo* pSClassInfo, bool isPrinted);

        //
        MPI::SClassInfo* GetClassData(MPI::TId classId);
        //
        //bool IsClassPrinted(MPI::TId classId);

        //
        bool IsClassStored(MPI::TId classId);

        bool IsMethodStored(MPI::TId  methodId);

        //
        void AddNewObjectData(MPI::SHeapEventData* pHeapEventData, bool isPrinted);
        //
        bool IsObjectStored(MPI::TId objectId);
        //
//        void AddNewMethodData(MPI::SMethodInfo* pSMethodInfo, MPI::TId methodId);
        // Add for bug 194081
        void DeleteMethodsData();
        // Add for bug 194081
        void AddNewMethodData(MPI::SMethodInfo* pSMethodInfo, MPI::TId methodId, bool isPrinted);
        //
        MPI::SMethodInfo* GetMethodData(MPI::TId methodId);
        //
        void SendCollectedData();
        //
        void CleanPrintFlags();
        //
        void CheckClassId(MPI::TId classId);
        //
        void CheckObjectId(MPI::TId objectId, MPI::TId threadId);
        //
        void CheckMethodId(MPI::TId methodId);
        // 
        void AddTimeOut(U64 timeOut, MPI::TId threadId);
        //
        U64 GetTimeOut(MPI::TId threadId);
        // Aggregated
        void AddNewStackEntry(MPI::TId threadId, MPI::TId methodId, U64 uiCpuNanos, bool is_active);
        // Aggregated
        void FinalizeStackEntry(MPI::TId threadId, U64 uiCpuNanos);
        // Aggregated
        void PrintAggCallGraph();
        // Aggregated
        void DeleteAggCallGraphData();


        int GetLineNumber(U64 location, MPI::SLineNumberTable* lineNumberTable);
        int GetLineNumber(U64 location, MPI::TId methodId);
        //
        void GetStackTrace(MPI::TId threadId, JPIAgent::SStackTrace_* stackTrace);
        void ConvertStackTrace(MPI::SThreadInfo* threadInfo, JPIAgent::SStackTrace_* stackTrace);
        void FreeStackTrace(JPIAgent::SStackTrace_* stackTrace);
        //
        void StoreThreadEvent(MPI::TId threadId, EventType type, void* data, U64 timeout, MPI::TId objectId = 0);
        void PrintStoredThreadEvents();
        void DeleteStoredThreadEvents();
        //
        void AddMethodLeaveData(MPI::TId threadId, MPI::TId methodId, MPI::TId classId, unsigned long ticket, U64 cpuTime);
        void PrintMethodLeaveData();
        //
        TResult GetThreadInfo(MPI::TId clientId, MPI::TId threadId, MPI::BitSet requestedDataTypes, MPI::SThreadInfo *pData);

        TResult AddSupportedEG(MPI::EEventGroup group);
        TResult DelSupportedEG(MPI::EEventGroup group);
        bool IsSupportedEG(MPI::EEventGroup group);
        TResult EnableSupportedEG();
        TResult DisableSupportedEG();

        //
        JPIAgent::EC_Env* ec_env;
        //
        bool m_profilerIsActive;

        bool m_enableDataCollection;

        // Ticket processing
        CTickets m_Tickets;
        //
        bool m_bVMInitDone;
        
        // Pointer to the MPI implementation
        MPI::IMpi *m_pMpiApi;
        // Client id for MPI requests
        MPI::TId m_clientId;
        // Profiler library name
        char* profName;
        
        // Add for bug 194081
        CCGShadowStackTracker* m_pShadowStackTracker;
        
    	// Filter some additional classes after reattach
    	bool IsExcludedClassMethod(const char* szClassName, const char* szMethodName);
        // Add for bug 194081
    private:
        CStackHead* AddThreadAggCallTree(MPI::TId threadId);
        CStackHead* GetThreadAggCallTree(MPI::TId threadId); // protected by lockAggObject

        typedef TResult (MPI::IMpi::*SET_EG_FUNC)(MPI::TId, MPI::EEventGroup);
        TResult SetSupportedEG(SET_EG_FUNC pSetEGFunc);
        
        int RemoveGenericsFromClassName(const char *pClassName, char *pNewClassName);
    private:
        std::vector<MPI::EEventGroup> m_implementedEG;
        
        CClassDefDataSet* m_pClassSData;
        OSA::IThreadSync* m_pClassSDataLockObject;

        CMethodDefDataSet* m_pMethodSData;
        OSA::IThreadSync* m_pMethodSDataLockObject;

        CObjectDataSet* m_pObjectSData;
        OSA::IThreadSync* m_pObjectSDataLockObject;

        CTIdSet* m_pMonitorTimeOuts;
        OSA::IThreadSync* m_pMonitorTimeOutsLockObject;

        CThreadEventsSet* m_pSThreadEventsData;
        OSA::IThreadSync* m_pSThreadEventsDataLockObject;

        CMethodLeaveDataSet* m_pSMethodLeaveData_;
        OSA::IThreadSync* m_pSSMethodLeaveData_LockObject;

        OSA::IThreadSync* lockClassDefObject;
        OSA::IThreadSync* lockObjectCheckObject;
        
        // Aggregated
        OSA::IThreadSync* lockAggObject;
        CStackHead* m_pStackSet;
        
        // For function GetThreadInfo
        OSA::IThreadSync* lockGetThreadInfoObject;
    };

} /*namespace Martini*/ } /*namespace BaseProf*/

#endif // _PROF_ENV_H_
