/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: StartEvent.cpp,v 1.8 2008/12/08 13:37:37 jkubasta Exp $ 
 ************************************************************************/

#include "StartEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::MPI;

CECStartEvent::CECStartEvent(){}
CECStartEvent::~CECStartEvent(){}

/*
 * Init - initializes internal data and registers for start event    
 */
TResult 
CECStartEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    m_iCountEvent = 0;
    TResult res = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return res;
}

/*
 * HandleEvent - callback function for start event
 */
void 
CECStartEvent::HandleEvent()
{
    m_iCountEvent ++;
    m_pProfEnv->SendCollectedData(); //TODO May be unnecessary
    m_pProfEnv->m_profilerIsActive = true;
    m_pProfEnv->PrintMethodLeaveData(); // CGProf
    m_pProfEnv->m_Tickets.PrintMethodEntryElements(m_pProfEnv->ec_env); // CGProf
    m_pProfEnv->PrintStoredThreadEvents();
    if(m_pProfEnv->IsSupportedEG(EG_HEAP) && m_pProfEnv->ec_env->isEnabled()){
        //Fix Bug216602. Only the first time Start Event in enabled mode will be handled.
        if(m_iCountEvent > 1) return;
        //Fix Bug241085, iterating heap and generating alloc event for live objects.
        m_pProfEnv->m_pMpiApi->GenerateObjectAllocEventForLiveObjects(m_pProfEnv->m_clientId);
    }
}
