/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: StartEvent.h,v 1.3 2008/12/08 13:37:37 jkubasta Exp $ 
 ************************************************************************/

#ifndef _START_EVENT_H_
#define _START_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace BaseProf {

    // CStartEvent - represents a Start event 
	class CECStartEvent : public MPI::IEcStartEventObserver
    {
    public:
        // Constructor
        CECStartEvent();
        // Destructor
        ~CECStartEvent();
        // Initialization - Register to event
        TResult Init(CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent();

    private:
        // profiler environment
        CProfEnv* m_pProfEnv;
        int m_iCountEvent;
    };

} /*namespace Martini*/ } /*namespace BaseProf*/

#endif // _START_EVENT_H_
