/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: StopEvent.cpp,v 1.3 2007/04/05 13:39:31 vrybalov Exp $ 
 ************************************************************************/

#include "StopEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::MPI;

CECStopEvent::CECStopEvent(){}
CECStopEvent::~CECStopEvent(){}

/*
 * Init - initializes internal data and registers for stop event    
 */
TResult 
CECStopEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult res = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return res;
}

/*
 * HandleEvent - callback function for stop event    
 */
void 
CECStopEvent::HandleEvent()
{
    m_pProfEnv->PrintAggCallGraph();
    m_pProfEnv->m_profilerIsActive = false;
    m_pProfEnv->CleanPrintFlags();
}
