/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: StopEvent.h,v 1.2 2007/03/23 14:04:45 vrybalov Exp $ 
 ************************************************************************/

#ifndef _STOP_EVENT_H_
#define _STOP_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace BaseProf {

    // CECStopEvent - represents a Stop event 
	class CECStopEvent : public MPI::IEcStopEventObserver
    {
    public:
        // Constructor
        CECStopEvent();
        // Destructor
        ~CECStopEvent();
        // Initialization - Register to event
        TResult Init(CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent();

    private:
        // profiler environment
        CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace BaseProf*/

#endif // _STOP_EVENT_H_
