/************************************************************************
 * Copyright (c) 2007, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: TIdSet.cpp,v 1.11 2008/05/13 05:28:29 aalexeev Exp $ 
 ************************************************************************/

#include "TIdSet.h"
#include "ProfEnv.h"

using namespace Martini::BaseProf;
using namespace Martini::MPI;
using namespace Martini::JPIAgent;

void 
CClassDefDataSet::PrintClassDefElements(EC_Env* ec_env) {
    if (m_less != 0) {
        ((CClassDefDataSet*)m_less)->PrintClassDefElements(ec_env) ;
    }
    if (!m_isPrinted) {
        ec_env->PrintClassDefElement(m_TId_Key, static_cast<SClassInfo*>(m_pData));
        m_isPrinted = true;
    }
    if (m_more != 0) {
        ((CClassDefDataSet*)m_more)->PrintClassDefElements(ec_env) ;
    }
}

/*
bool 
CClassDefDataSet::IsClassPrinted(TId tId_Key, EC_Env* ec_env) {
    if (m_TId_Key == tId_Key) {
        return m_isPrinted;
    }  else if (tId_Key < m_TId_Key) {
        if (m_less != 0) {
            return ((CClassDefDataSet*)m_less)->IsClassPrinted(tId_Key, ec_env);
        }
    } else {
        if (m_more != 0) {
            return ((CClassDefDataSet*)m_more)->IsClassPrinted(tId_Key, ec_env);
        }
    }
    return false;
}
*/

bool 
CClassDefDataSet::IsClassStored(TId tId_Key) {
    if (m_TId_Key == tId_Key) {
        return true;
    }  else if (tId_Key < m_TId_Key) {
        if (m_less != 0) {
            return ((CClassDefDataSet*)m_less)->IsClassStored(tId_Key);
        }
    } else {
        if (m_more != 0) {
            return ((CClassDefDataSet*)m_more)->IsClassStored(tId_Key);
        }
    }
    return false;
}




//==============================================================================

void 
CMethodDefDataSet::PrintMethodDefElements(EC_Env* ec_env) {
    if (m_less != 0) {
        ((CMethodDefDataSet*)m_less)->PrintMethodDefElements(ec_env);
    }
    if (!m_isPrinted) {
        ec_env->PrintMethodDefElement(m_TId_Key, static_cast<SMethodInfo*>(m_pData));
        m_isPrinted = true;
    }
    if (m_more != 0) {
        ((CMethodDefDataSet*)m_more)->PrintMethodDefElements(ec_env);
    }
}

/*
bool 
CMethodDefDataSet::IsMethodPrinted(TId tId_Key, EC_Env* ec_env) {
    if (m_TId_Key == tId_Key) {
        if (!m_isPrinted) {
            ec_env->PrintMethodDefElement(m_TId_Key, static_cast<SMethodInfo*>(m_pData));
            m_isPrinted = true;
        }
        return true;
    }   else if (tId_Key < m_TId_Key) {
        if (m_less != 0) {
            return ((CMethodDefDataSet*)m_less)->IsMethodPrinted(tId_Key, ec_env);
        }
    } else {
        if (m_more != 0) {
            return ((CMethodDefDataSet*)m_more)->IsMethodPrinted(tId_Key, ec_env);
        }
    }
    return false;
}
*/

bool 
CMethodDefDataSet::IsMethodStored(TId tId_Key) {
    if (m_TId_Key == tId_Key) {
        return true;
    }   else if (tId_Key < m_TId_Key) {
        if (m_less != 0) {
            return ((CMethodDefDataSet*)m_less)->IsMethodStored(tId_Key);
        }
    } else {
        if (m_more != 0) {
            return ((CMethodDefDataSet*)m_more)->IsMethodStored(tId_Key);
        }
    }
    return false;
}


//==============================================================================
void 
CObjectDataSet::PrintObjAllocElements(CProfEnv* env) {
    if (m_less != 0) {
        ((CObjectDataSet*)m_less)->PrintObjAllocElements(env) ;
    }
    SHeapEventData* heapEventData = static_cast<SHeapEventData*>(m_pData);
    U64 lineNumber = 0xffffffff;
    if (((heapEventData->validData & DR_METHOD_ID) != 0) && ((heapEventData->validData & DR_ALLOC_VM_INSTRUCTION_OFFSET) != 0)) {
        env->GetLineNumber(heapEventData->allocLocation, heapEventData->allocMethodId);
    }
    env->ec_env->PrintObjAllocElement(heapEventData, lineNumber);
    m_isPrinted = true;
    if (m_more != 0) {
        ((CObjectDataSet*)m_more)->PrintObjAllocElements(env) ;
    }
}

bool 
CObjectDataSet::IsObjectStored(TId tId_Key) 
{
    if (m_TId_Key == tId_Key) {
        return true;
    }   else if (tId_Key < m_TId_Key) {
        if (m_less != 0) {
            return ((CObjectDataSet*)m_less)->IsObjectStored(tId_Key);
        }
    } else {
        if (m_more != 0) {
            return ((CObjectDataSet*)m_more)->IsObjectStored(tId_Key);
        }
    }
    return false;
}

//==============================================================================
void 
CMethodLeaveDataSet::PrintMethodLeaveElements(EC_Env* ec_env)
{
    if (m_more != 0) {
        ((CMethodLeaveDataSet*)m_more)->PrintMethodLeaveElements(ec_env);
    }
    SMethodLeaveData_* methodLeaveData = static_cast<SMethodLeaveData_*>(m_pData);
    ec_env->PrintMethodExitElement(methodLeaveData->threadId_, methodLeaveData->methodId_, 
        methodLeaveData->classId_, methodLeaveData->ticket_, methodLeaveData->cpuTime_);
    m_isPrinted = true;
    if (m_less != 0) {
        ((CMethodLeaveDataSet*)m_less)->PrintMethodLeaveElements(ec_env);
    }
}

//==============================================================================

void
CThreadEventsSet::PrintStoredThreadEvents(CProfEnv* env)
{
    if (m_less != 0) {
        ((CThreadEventsSet*)m_less)->PrintStoredThreadEvents(env);
    }
    if (m_pData != 0){
        SThreadEventsData* evdata = (SThreadEventsData*)m_pData;
        if (evdata->isNewThread) {
                if (evdata->objectId != 0) {
                    env->CheckObjectId(evdata->objectId, evdata->threadId);
                }
                env->ec_env->PrintThreadStartElement(evdata->threadId, evdata->objectId, &(evdata->threadInfo));
                evdata->isNewThread = false;
        }
        switch (evdata->type) {
            case CONTENDED_MONITOR_ENTERED_EVENT:
                env->CheckObjectId(evdata->data.cedData.objectId, evdata->threadId);
                env->ec_env->PrintMonitorContendedEnteredElement(&(evdata->data.cedData), 0);
                break;
            case CONTENDED_MONITOR_ENTER_EVENT:
                env->CheckObjectId(evdata->data.cedData.objectId, evdata->threadId);
                env->ec_env->PrintMonitorContendedEnterElement(&(evdata->data.cerData), 0);
                break;
            case MONITOR_WAITED_EVENT:
                env->CheckObjectId(evdata->data.cedData.objectId, evdata->threadId);
                env->ec_env->PrintMonitorWaitedElement(&(evdata->data.wedData), evdata->timeout, 0);
                break;
            case MONITOR_WAIT_EVENT:
                env->CheckObjectId(evdata->data.cedData.objectId, evdata->threadId);
                env->ec_env->PrintMonitorWaitElement(&(evdata->data.wetData), 0);
                break;
            case THREAD_END_EVENT:
                env->ec_env->PrintThreadEndElement(evdata->threadId);
                break;
            case THREAD_START_EVENT:
                break;
        }
    }
    if (m_more != 0) {
        ((CThreadEventsSet*)m_more)->PrintStoredThreadEvents(env);
    }
}
