/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: VMInitEvent.cpp,v 1.4 2008/11/21 17:49:18 jkubasta Exp $ 
 ************************************************************************/

#include "VMInitEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::MPI;

CVMInitEvent::CVMInitEvent(){}
CVMInitEvent::~CVMInitEvent(){}

/*
 * Init - initializes internal data and registers for VM shutdown event    
 */
TResult 
CVMInitEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult res = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return res;
}

/*
 * HandleEvent - callback function for VM shutdown event    
 */
void 
CVMInitEvent::HandleEvent(SVmInitEventData &data)
{
    m_pProfEnv->m_bVMInitDone = true;
    if (!m_pProfEnv->m_profilerIsActive) {
        m_pProfEnv->ec_env->VMInitDone();
        return;
    }
    LOG_ASSERT(data.validData == DR_THREAD_ID);
    m_pProfEnv->ec_env->PrintRuntimeVMInitElement(data.threadId);
    m_pProfEnv->ec_env->VMInitDone();

    //if(m_pProfEnv->IsSupportedEG(EG_HEAP)){
        //Fix Bug241085.
        //m_pProfEnv->m_pMpiApi->GenerateObjectAllocEventForLiveObjects(m_pProfEnv->m_clientId);
    //}

}
