/************************************************************************
 * Copyright (c) 2006 - 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: VMShutdownEvent.cpp,v 1.7 2009/08/31 07:03:13 yhe Exp $ 
 ************************************************************************/

#include "VMShutdownEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::MPI;

CVMShutdownEvent::CVMShutdownEvent(){}
CVMShutdownEvent::~CVMShutdownEvent(){}

/*
 * Init - initializes internal data and registers for VM shutdown event    
 */
TResult 
CVMShutdownEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    // register for VM shutdown event
    TResult res = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return res;
}

/*
 * HandleEvent - callback function for VM shutdown event    
 */
void 
CVMShutdownEvent::HandleEvent()
{
    if (!m_pProfEnv->m_profilerIsActive) {
        return;
    }
    // Modified for bug 194081
    m_pProfEnv->m_pShadowStackTracker->TrackVMShutdown();
    
    if (!m_pProfEnv->ec_env->isCGExecDetails())
    {
        m_pProfEnv->PrintAggCallGraph();
    }
    // Modified for bug 194081
    
    m_pProfEnv->ec_env->PrintRuntimeShutdownElement();
}
