/************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: CallGraphProfiler.cpp,v 1.19 2010/09/08 21:10:58 mreid Exp $ 
 ************************************************************************/

#include "CallGraphProfiler.h"
#include <string.h>

#ifdef MVS
#	include <strings.h>	// For strcasecmp
#endif

using namespace Martini::BaseProf;
using namespace Martini::CGProf;
using namespace Martini::MPI;

/*
 *    MPICL_Instantiate - The profiler initialization method. 
 *    The profiler initializes itself and registers for MPI events 
 */
extern "C" API_EXPORT TResult 
MPICL_Instantiate(IMpi *pMpiApi, TId clientId, const char *szOptions)
{
    LOG_ASSERT(pMpiApi != 0);
    LOG_ASSERT(clientId != 0);
    static CCallGraphProfiler s_CallGraphProfiler;
    return s_CallGraphProfiler.Init(pMpiApi, clientId, szOptions);
}

//=======================================================================================

CCallGraphProfiler::CCallGraphProfiler()
{
    m_profilerName = "Call Graph profiler";
    m_pProfEnv.profName = "org.eclipse.tptp.analysisType.jvmti.execution"; // fixed for 190684
    m_pProfEnv.AddSupportedEG(EG_CALL_GRAPH);
}

CCallGraphProfiler::~CCallGraphProfiler()
{
}

/*
 * InitEvents - initialize profiler specific object event - register events
 */
TResult 
CCallGraphProfiler::InitProfilerSpecificEvents() 
{
    TResult retVal;
    retVal = m_customCommandHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of CustomCommand event failed: " << retVal);
        return retVal;
    }
    retVal = m_methodEnterHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of MethodEnter event failed: " << retVal);
        return retVal;
    }
    retVal = m_methodLeaveHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of MethodLeave event failed: " << retVal);
        return retVal;
    }
    // New method will be added when MethodEnter handle, no need for additional handling in CGProf
    /*
    retVal = m_newMethodHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of NewMethod event failed: " << retVal);
        return retVal;
    }
    */
    retVal = m_threadStartHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of ThreadStart event failed: " << retVal);
        return retVal;
    }
    retVal = m_threadEndHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of ThreadEnd event failed: " << retVal);
        return retVal;
    }
    return retVal;
}


TResult 
CCallGraphProfiler::InitFilter()
{
    // register to filter
    static CCallGraphFilter filter(&m_pProfEnv);
    TResult retVal = m_pProfEnv.m_pMpiApi->SetEventGroupFilter(m_pProfEnv.m_clientId, Martini::MPI::EG_CALL_GRAPH, filter);
    if (MRTE_SUCCEEDED(retVal)) {
        LOG_TRACE(m_profilerName << " filter: init success");
    } else {
        LOG_ERROR(m_profilerName << " filter: init failed");
    }
    return retVal;
}

TResult 
CCallGraphProfiler::ParceOptions(const char *szOptions)
{
#ifndef _WIN32
#define stricmp strcasecmp 
#endif
    if (stricmp("execdetails=false", szOptions) == 0) {
        m_pProfEnv.ec_env->SetProfileOption("EXECDETAILS", "false");
    } else if (stricmp("execdetails=true", szOptions) == 0) {
        m_pProfEnv.ec_env->SetProfileOption("EXECDETAILS", "true");
    } else if (stricmp("", szOptions) == 0) {
    } else {
        fprintf(stderr, "Unknown profiler option %s. Use defaults.\n", szOptions);
    }
    return MRTE_RESULT_OK;
}
//=======================================================================================

CCallGraphFilter::CCallGraphFilter(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
}

bool 
CCallGraphFilter::ShouldNotify(SCallGraphFilterData &data)
{
    if (m_pProfEnv->ec_env->IsExcluded(data.szClassName, data.szMethodName)) {
        return false;
    }
    return true;
}
