/************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: CallGraphProfiler.h,v 1.10 2009/09/10 21:17:35 jcayne Exp $ 
 ************************************************************************/

#ifndef _CALL_GRAPH_PROFILER_H_
#define _CALL_GRAPH_PROFILER_H_

#include "BaseProfiler.h"
#include "MethodEnterEvent.h"
#include "MethodLeaveEvent.h"
//#include "NewMethodEvent.h"
#include "ThreadStartEvent.h"
#include "ThreadEndEvent.h"
#include "CustomCommandEvent.h"

namespace Martini { namespace CGProf {

    class CCallGraphFilter : public MPI::ICallGraphFilter
    {
    public:
        CCallGraphFilter(BaseProf::CProfEnv* profEnv);
        bool ShouldNotify(MPI::SCallGraphFilterData &data);
    private:
        // profilrt env object
        BaseProf::CProfEnv* m_pProfEnv;
    };

    class CCallGraphProfiler : public BaseProf::CBaseProfiler
    {
    public:
        // Constructor
        CCallGraphProfiler();
        // Destructor
        ~CCallGraphProfiler();
        // Initialization

    protected:
        virtual TResult InitProfilerSpecificEvents();
        virtual TResult InitFilter();
        virtual TResult ParceOptions(const char *szOptions);

    private:
        // Method enter event object
        CMethodEnterEvent   m_methodEnterHandler;
        // Method leave event object
        CMethodLeaveEvent   m_methodLeaveHandler;
        // New method event object
        //CNewMethodEvent     m_newMethodHandler;
        // Thread start event object
        CThreadStartEvent   m_threadStartHandler;
        // Thread end event object
        CThreadEndEvent     m_threadEndHandler;
        // CustomCommand event object
        CCustomCommandEvent m_customCommandHandler;
    };

} /*namespace Martini*/  } /*namespace CGProf*/

#endif // _CALL_GRAPH_PROFILER_H_
