/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: CustomCommandEvent.cpp,v 1.4 2007/08/24 17:29:24 gnagarajan Exp $ 
 ************************************************************************/

#include "CustomCommandEvent.h"

using namespace Martini::CGProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;

CCustomCommandEvent::CCustomCommandEvent(){}
CCustomCommandEvent::~CCustomCommandEvent(){}

/*
 * Init - initializes internal data and registers for VM shutdown event    
 */
TResult 
CCustomCommandEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    return profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
}

/*
 * HandleEvent - callback function for VM shutdown event    
 */
void 
CCustomCommandEvent::HandleEvent(SCustomCommandEventData &data)
{
    static TId heapDumpId = 1;
    LOG_ASSERT((data.validData & DR_COMMAND_ID) != 0);

    if (data.commandId == JPIAgent::ENABLE_DATA_COLLECTION) {
		m_pProfEnv->m_enableDataCollection = true;
        return;
    }

    if (!m_pProfEnv->m_profilerIsActive) {
        return;
    }
    switch (data.commandId) {
        case JPIAgent::COLLECT_DATA: {
            m_pProfEnv->PrintAggCallGraph();
            break;
         }
    }
}
