/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: CustomCommandEvent.h,v 1.3 2007/03/23 14:04:43 vrybalov Exp $ 
 ************************************************************************/

#ifndef _CUSTOM_COMMAND_EVENT_H_
#define _CUSTOM_COMMAND_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace CGProf {

    // CCustomCommandEvent - represents a Custom Command event 
    class CCustomCommandEvent : public MPI::IEcCustomCommandEventObserver
    {
    public:
        // Constructor
        CCustomCommandEvent();
        // Destructor
        ~CCustomCommandEvent();
        // Initialization - Register to event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SCustomCommandEventData &data);

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace CGProf*/

#endif // _CUSTOM_COMMAND_EVENT_H_
