/************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: MethodEnterEvent.cpp,v 1.15 2009/11/25 02:07:08 cdeng Exp $ 
 ************************************************************************/


#include "MethodEnterEvent.h"

#include <string.h>

using namespace Martini::BaseProf;
using namespace Martini::CGProf;
using namespace Martini::MPI;

CMethodEnterEvent::CMethodEnterEvent(){}
CMethodEnterEvent::~CMethodEnterEvent(){}

/*
 * Init - initializes internal data and registers for enter method event
 */
TResult 
CMethodEnterEvent::Init(CProfEnv* profEnv)
{    
    m_pProfEnv = profEnv;
    // register for enter method event
    return profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
}

/*
 * HandleEvent - callback function for enter method event    
 */
void 
CMethodEnterEvent::HandleEvent(Martini::MPI::SMethodEnterEventData &data)
{
    if (!m_pProfEnv->m_profilerIsActive) return;  //profiler is in pause mode, add for bug 289485
    LOG_ASSERT((data.validData & DR_METHOD_ID) != 0);
    LOG_ASSERT((data.validData & DR_THREAD_ID) != 0);
    LOG_ASSERT((data.validData & DR_THREAD_CPU_TIME) != 0);
    
    // Add for bug 194081
    m_pProfEnv->m_pShadowStackTracker->TrackMethodEnter(data);
    // Add for bug 194081

    SMethodInfo classInfo;
    TResult iRes = m_pProfEnv->m_pMpiApi->GetMethodInfo(m_pProfEnv->m_clientId, data.methodId, 
        DR_CLASS_ID, &classInfo);
    LOG_ASSERT(iRes == MRTE_RESULT_OK);
    LOG_ASSERT((classInfo.validData & DR_CLASS_ID) != 0);

    m_pProfEnv->CheckMethodId(data.methodId);
    if (m_pProfEnv->ec_env->isCGExecDetails()) {
        //profiler is active
        unsigned long ticket = m_pProfEnv->m_Tickets.GetNewTicket(data.threadId, data.uiCpuNanos, true);
        unsigned long stackDepth = m_pProfEnv->m_Tickets.GetStackDepth(data.threadId);
        m_pProfEnv->ec_env->PrintMethodEntryElement(data.threadId, data.methodId, classInfo.classId, ticket, stackDepth);
    } else {
        m_pProfEnv->AddNewStackEntry(data.threadId, data.methodId, data.uiCpuNanos, m_pProfEnv->m_profilerIsActive);
    }
}

BitSet 
CMethodEnterEvent::EventDataTypes()
{
    return DR_METHOD_ID | DR_THREAD_ID | DR_THREAD_CPU_TIME;
}
