/************************************************************************
 * Copyright (c) 2005 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: MethodEnterEvent.h,v 1.5 2007/03/23 14:04:42 vrybalov Exp $ 
 ************************************************************************/

#ifndef _METHOD_ENTER_EVENT_H_
#define _METHOD_ENTER_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "Tickets.h"
#include "log.h"

namespace Martini { namespace CGProf {

    // CMethodEnterEvent - represents a selective enter method event 
	class CMethodEnterEvent : public MPI::IMethodEnterEventObserver
    {
    public:
        // Constructor
        CMethodEnterEvent();
        // Destructor
        ~CMethodEnterEvent();
        // Initializes internal data and registers for enter method event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SMethodEnterEventData &data);
        MPI::BitSet EventDataTypes();

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace CGProf*/

#endif // _METHOD_ENTER_EVENT_H_
