/************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: MethodLeaveEvent.cpp,v 1.17 2009/11/25 02:07:07 cdeng Exp $ 
 ************************************************************************/

#include "MethodLeaveEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::CGProf;
using namespace Martini::MPI;

CMethodLeaveEvent::CMethodLeaveEvent(){}
CMethodLeaveEvent::~CMethodLeaveEvent(){}

/*
 * Init - initializes internal data and registers for leave method event
 */
TResult 
CMethodLeaveEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    // register for leave method event
    TResult retVal = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return retVal;
}

/*
 * HandleEvent - callback function for leave method event    
 */
void 
CMethodLeaveEvent::HandleEvent(Martini::MPI::SMethodLeaveEventData &data)
{
    if (!m_pProfEnv->m_profilerIsActive) return;  //profiler is in pause mode, add for bug 289485
    LOG_ASSERT((data.validData & DR_METHOD_ID) != 0);
    LOG_ASSERT((data.validData & DR_THREAD_ID) != 0);
    LOG_ASSERT((data.validData & DR_THREAD_CPU_TIME) != 0);
    
    // Add for bug 194081
    bool isContinueHandleMethodLeave = m_pProfEnv->m_pShadowStackTracker->TrackMethodLeave(data);
    if (!isContinueHandleMethodLeave)
    {
        return;
    }
    // Add for bug 194081

    SMethodInfo classInfo;
    TResult iRes = m_pProfEnv->m_pMpiApi->GetMethodInfo(m_pProfEnv->m_clientId, data.methodId, 
        DR_CLASS_ID, &classInfo);
    LOG_ASSERT(iRes == MRTE_RESULT_OK);
    LOG_ASSERT((classInfo.validData & DR_CLASS_ID) != 0);

    if (m_pProfEnv->ec_env->isCGExecDetails()) {
    	U64 cpuTime = data.uiCpuNanos - m_pProfEnv->m_Tickets.GetCpuTime(data.threadId);
        unsigned long ticket = m_pProfEnv->m_Tickets.ReleaseTicket(data.threadId);
        m_pProfEnv->ec_env->PrintMethodExitElement(data.threadId, data.methodId, classInfo.classId, ticket, cpuTime);
    } else {
        m_pProfEnv->FinalizeStackEntry(data.threadId, data.uiCpuNanos);
    }
}

BitSet 
CMethodLeaveEvent::EventDataTypes()
{
    return DR_METHOD_ID | DR_THREAD_ID | DR_THREAD_CPU_TIME;
}
