/************************************************************************
 * Copyright (c) 2005 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: NewMethodEvent.cpp,v 1.6 2007/08/24 17:29:24 gnagarajan Exp $ 
 ************************************************************************/

#include "NewMethodEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::CGProf;
using namespace Martini::MPI;

CNewMethodEvent::CNewMethodEvent(){}
CNewMethodEvent::~CNewMethodEvent(){}

/*
 * Init    - initializes internal data and registers for new method event    
 */
TResult 
CNewMethodEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    // register for new method event
    TResult retVal = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return retVal;
}

/*
 * HandleEvent - callback function for new method event    
 */
void 
CNewMethodEvent::HandleEvent(SNewMethodEventData &data)
{
    LOG_ASSERT((data.validData & DR_METHOD_ID) != 0);

    // request data for the specific new method 
    m_pProfEnv->CheckMethodId(data.methodId);
}
