/************************************************************************
 * Copyright (c) 2005 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: NewMethodEvent.h,v 1.6 2007/03/23 14:04:41 vrybalov Exp $ 
 ************************************************************************/


#ifndef _NEW_METHOD_EVENT_H_
#define _NEW_METHOD_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace CGProf {

    // CNewMethodEvent - represents a new method event 
	class CNewMethodEvent : public MPI::INewMethodEventObserver
    {
    public:
        // Constructor
        CNewMethodEvent();
        // Destructor
        ~CNewMethodEvent();
        // Initializes internal data and registers new method event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SNewMethodEventData &data);

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace CGProf*/

#endif // _NEW_METHOD_EVENT_H_
