/************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ThreadStartEvent.cpp,v 1.11 2009/09/10 21:17:35 jcayne Exp $ 
 ************************************************************************/

#include "ThreadStartEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::CGProf;
using namespace Martini::MPI;

CThreadStartEvent::CThreadStartEvent(){}
CThreadStartEvent::~CThreadStartEvent(){}

/*
 * Init - initializes internal data and registers for thread start event    
 */
TResult 
CThreadStartEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult retVal = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return retVal;
}

/*
 * HandleEvent - callback function for thread start event    
 */
void 
CThreadStartEvent::HandleEvent(SThreadEventData &data)
{
    LOG_ASSERT(data.validData == DR_THREAD_ID);
    m_pProfEnv->m_Tickets.AddNewThread(data.threadId);
    // request thread information
    SThreadInfo threadInfo = {0};
    TResult iRes = m_pProfEnv->GetThreadInfo(m_pProfEnv->m_clientId, data.threadId, 
            DR_THREAD_INFO, &threadInfo);
//    if (iRes == MRTE_ERROR_PHASE_FAILURE) {   TODO check it
//        LOG_TRACE("Thread start event (GetThreadInfo wrong phase), Id:" << data.threadId);
//        return;
//    }
    if (iRes != MRTE_RESULT_OK) {
//        LOG_DIE("GetThreadInfo failed");
        LOG_TRACE("Thread start event (GetThreadInfo wrong phase)");
        return;
    }
    
    if (m_pProfEnv->m_profilerIsActive) 
    {
        m_pProfEnv->ec_env->PrintThreadStartElement(data.threadId, 0, &threadInfo);
    }
    else
    {
        m_pProfEnv->StoreThreadEvent(data.threadId, THREAD_START_EVENT, &threadInfo, 0);
    }
}
