/************************************************************************
 * Copyright (c) 2006, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: CustomCommandEvent.cpp,v 1.6 2010/05/25 14:48:19 jcayne Exp $ 
 ************************************************************************/

#include "CustomCommandEvent.h"

using namespace Martini::HeapProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;

CCustomCommandEvent::CCustomCommandEvent(){}
CCustomCommandEvent::~CCustomCommandEvent(){}

/*
 * Init - initializes internal data and registers for VM shutdown event    
 */
TResult 
CCustomCommandEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    return profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
}

/*
 * HandleEvent - callback function for VM shutdown event    
 */
void 
CCustomCommandEvent::HandleEvent(SCustomCommandEventData &data)
{
    static TId heapDumpId = 1;
    LOG_ASSERT((data.validData & DR_COMMAND_ID) != 0);

    if (data.commandId == JPIAgent::ENABLE_DATA_COLLECTION) {
		m_pProfEnv->m_enableDataCollection = true;
        return;
    } else if (data.commandId == JPIAgent::SET_HEAP_OBJ_COLLECTION_CMD) {
		// Handles the event to set the option for heap object collection inside Martini.
		// The profiler may not be active at this time.
		m_pProfEnv->m_pMpiApi->SetHeapObjDataCollection((*((bool *)data.pData)));
		return;
    }

    if (!m_pProfEnv->m_profilerIsActive) {
        return;
    }

    switch (data.commandId) {
        case JPIAgent::ANALYSE_HEAP_COMMAND: {
            SObjectReferenceInfo data;
            TResult retVal = m_pProfEnv->m_pMpiApi->GetObjectReferences(m_pProfEnv->m_clientId, &data);
            if (MRTE_FAILED(retVal)) {
                LOG_ERROR("Analyse Heap failed: " << retVal);
                return;
            }
            TId currentHeapDumpId = heapDumpId++;
            m_pProfEnv->ec_env->PrintHeapDumpDefElement(currentHeapDumpId, "Default", 0); //TODO baseTime?
            for (int i = 0; i < data.uiActualSize; i++) {
                switch (data.pReferences[i].type) {
                    case OR_OTHER:
                        LOG_TRACE("OTHER object reference is provided");
                    case OR_SYSTEM_CLASS:
                    case OR_MONITOR:
                    case OR_STACK_LOCAL:
                    case OR_JAVA_JNI_LOCAL:
                    case OR_THREAD: 
                        m_pProfEnv->ec_env->PrintGcRootElement(currentHeapDumpId, data.pReferences[i].srcObjectId, data.pReferences[i].type);
                        break;
                    case OR_CLASS:
                    case OR_FIELD:
                    case OR_ARRAY_ELEMENT:
                    case OR_JAVA_CLASS_LOADER:
                    case OR_JAVA_REFERENCE_SIGNERS:
                    case OR_JAVA_PROTECTION_DOMAIN:
                    case OR_INTERFACE:
                    case OR_STATIC_FIELD:
                    case OR_CONSTANT_POOL:
                    case OR_SUPERCLASS:
                        m_pProfEnv->ec_env->PrintObjectReferenceElement(currentHeapDumpId, &(data.pReferences[i]));
                        break;
                }
            }
            break;
        }
        case JPIAgent::RUN_GC_COMMAND: {
            TResult retVal = m_pProfEnv->m_pMpiApi->RunGC();
            break;
        }
        // The custom command to collect Object data was sent.
        // Connect to the Martini infrastructure using MPI and retrieve
        // the information about the Object.
        case JPIAgent::RUN_HEAP_OBJ_DATA_COLLECTION_CMD: {

        	// Check if heap object collection is enabled
        	if (!m_pProfEnv->ec_env->isHeapInstanceDataEnabled()) {
        		break;
        	}
        	// Obtains information about the data stored within the Object using the TPTP ID.
        	// The result is stored in THeapObjectAnalysis->resultValue, this value is NULL if the result
        	// returned is a failure, the size of the result is 0, or the size of the result is too large.
		   	TResult retVal = m_pProfEnv->m_pMpiApi->RunHeapObjDataCollection((THeapObjectAnalysis *)data.pData);
			
			if (MRTE_FAILED(retVal)) {
                LOG_ERROR("Heap Object Instance data collection failed: " << retVal);
                return;
            }
            
            LOG_TRACE("Heap Object Instance data collection completed.");
		   	break;
		}
    }
}
