/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: GcStartEvent.h,v 1.2 2007/03/23 14:04:45 vrybalov Exp $ 
 ************************************************************************/

#ifndef _GC_START_EVENT_H_
#define _GC_START_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace HeapProf {

    // CGcStartEvent - represents thread end event 
    class CGcStartEvent : public MPI::IGcStartEventObserver
    {
    public:
        // Constructor
        CGcStartEvent();
        // Destructor
        ~CGcStartEvent();
        // Initializes internal data and registers thread end event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent();

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace HeapProf*/

#endif // _GC_START_EVENT_H_

