/************************************************************************
 * Copyright (c) 2006, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: HeapProfiler.cpp,v 1.14 2010/08/17 16:30:00 jwest Exp $ 
 ************************************************************************/

#include "HeapProfiler.h"

#ifdef MVS
	#include <strings.h>
#endif
#include <string.h>

using namespace Martini::BaseProf;
using namespace Martini::HeapProf;
using namespace Martini::MPI;

/*
 *    MPICL_Instantiate - The profiler initialization method. 
 *    The profiler initializes itself and registers for MPI events 
 */
extern "C" API_EXPORT TResult 
MPICL_Instantiate(IMpi *pMpiApi, TId clientId, const char *szOptions)
{
    LOG_ASSERT(pMpiApi != 0);
    LOG_ASSERT(clientId != 0);
    static Martini::HeapProf::CHeapProfiler s_HeapProfiler;
    return s_HeapProfiler.Init(pMpiApi, clientId, szOptions);
}

//=======================================================================================

CHeapProfiler::CHeapProfiler()
{
    m_profilerName = "Heap profiler";
    m_pProfEnv.profName = "org.eclipse.tptp.analysisType.jvmti.heap";  // fixed for 190684
    m_pProfEnv.AddSupportedEG(EG_HEAP);
}

CHeapProfiler::~CHeapProfiler()
{
}

/*
 * InitEvents - initialize profiler specific object event - register events
 */
TResult 
CHeapProfiler::InitProfilerSpecificEvents()
{
    TResult retVal;
    retVal = m_customCommandHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of CustomCommand event failed: " << retVal);
        return retVal;
    }
    retVal = m_threadStartHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of ThreadStart event failed: " << retVal);
        return retVal;
    }
    retVal = m_threadEndHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of ThreadEnd event failed: " << retVal);
        return retVal;
    }
    retVal = m_objAllocHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of ObjAlloc event failed: " << retVal);
        return retVal;
    }
    retVal = m_objFreeHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of ObjFree event failed: " << retVal);
        return retVal;
    }
    retVal = m_gcStartHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of GcStart event failed: " << retVal);
        return retVal;
    }
    retVal = m_gcFinishHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of GcFinish event failed: " << retVal);
        return retVal;
    }
    if (m_pProfEnv.ec_env->isAllocSitesSupported()) {
        retVal = m_newMethodHandler.Init(&m_pProfEnv);
        if (MRTE_FAILED(retVal)) {
            LOG_ERROR("Initialization of NewMethod event failed: " << retVal);
            return retVal;
        }
    }
    return MRTE_RESULT_OK;
}

TResult 
CHeapProfiler::InitFilter()
{
    // register to filter
    static CHeapFilter filter(&m_pProfEnv);
    TResult retVal = m_pProfEnv.m_pMpiApi->SetEventGroupFilter(m_pProfEnv.m_clientId, Martini::MPI::EG_HEAP, filter);
    if (MRTE_SUCCEEDED(retVal)) {
        LOG_TRACE(m_profilerName << " filter: init success");
    } else {
        LOG_ERROR(m_profilerName << " filter: init failed");
    }
    return retVal;
}

TResult 
CHeapProfiler::ParceOptions(const char *szOptions)
{
#ifndef _WIN32
#define stricmp strcasecmp 
#endif
	char * options = (char*)malloc(strlen(szOptions) +1);
	strcpy(options, szOptions);

	// Handles for more than one option passed separated by commas.
	char * szSubOption = strtok(options, ",");
	while(szSubOption != NULL) {
		if (stricmp("allocsites=false", szSubOption) == 0) {
			m_pProfEnv.ec_env->SetProfileOption("ALLOCSITES", "false");
		} else if (stricmp("allocsites=true", szSubOption) == 0) {
			m_pProfEnv.ec_env->SetProfileOption("ALLOCSITES", "true");
		} else if (stricmp("heapInstanceData=false", szSubOption) == 0) {
			m_pProfEnv.ec_env->SetProfileOption("HEAPINSTANCEDATA", "false");
		} else if (stricmp("heapInstanceData=true", szSubOption) == 0) {
			m_pProfEnv.ec_env->SetProfileOption("HEAPINSTANCEDATA", "true");
		} else if (stricmp("", szSubOption) == 0) {
		} else {
			fprintf(stderr, "Unknown profiler option %s. Using the default for this option.\n", szSubOption);
		}
		szSubOption = strtok(NULL, ",");
	}
	free(options);
    return MRTE_RESULT_OK;
}

//=======================================================================================

CHeapFilter::CHeapFilter(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
}

bool 
CHeapFilter::ShouldNotify(SHeapFilterData &data)
{
    if (m_pProfEnv->ec_env->IsExcluded(data.szClassName, "")) {
        return false;
    }
    return true;
}

