/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: HeapProfiler.h,v 1.5 2007/03/23 14:04:45 vrybalov Exp $ 
 ************************************************************************/

#ifndef _HEAP_PROFILER_H_
#define _HEAP_PROFILER_H_

#include "BaseProfiler.h"
#include "ThreadStartEvent.h"
#include "ThreadEndEvent.h"
#include "ObjAllocEvent.h"
#include "ObjFreeEvent.h"
#include "GcStartEvent.h"
#include "GcFinishEvent.h"
#include "CustomCommandEvent.h"
#include "NewMethodEvent.h"

namespace Martini { namespace HeapProf {

    class CHeapFilter : public MPI::IHeapFilter
    {
    public:
        CHeapFilter(BaseProf::CProfEnv* profEnv);
        bool ShouldNotify(MPI::SHeapFilterData &data);
    private:
        // profilrt env object
        BaseProf::CProfEnv* m_pProfEnv;
    };

    class CHeapProfiler : public BaseProf::CBaseProfiler
    {
    public:
        // Constructor
        CHeapProfiler();
        // Destructor
        ~CHeapProfiler();

    protected:
        virtual TResult InitProfilerSpecificEvents();
        virtual TResult InitFilter();
        virtual TResult ParceOptions(const char *szOptions);

    private:
        // Thread start event object
        CThreadStartEvent   m_threadStartHandler;
        // Thread end event object
        CThreadEndEvent     m_threadEndHandler;
        // ObjAlloc event object
        CObjAllocEvent      m_objAllocHandler;
        // ObjFree event object
        CObjFreeEvent       m_objFreeHandler;
        // GcStart event object
        CGcStartEvent       m_gcStartHandler;
        // GcFinish event object
        CGcFinishEvent      m_gcFinishHandler;
        // CustomCommand event object
        CCustomCommandEvent m_customCommandHandler;
        // New method event object
        CNewMethodEvent     m_newMethodHandler;
    };

} /*namespace Martini*/  } /*namespace HeapProf*/

#endif // _HEAP_PROFILER_H_
