/************************************************************************
 * Copyright (c) 2006, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ObjAllocEvent.cpp,v 1.8 2009/05/20 03:35:02 kchan Exp $ 
 ************************************************************************/

#include "ObjAllocEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::HeapProf;
using namespace Martini::MPI;

CObjAllocEvent::CObjAllocEvent(){}
CObjAllocEvent::~CObjAllocEvent(){}

/*
 * Init - initializes internal data and registers for thread end event    
 */
TResult 
CObjAllocEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    return profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
}

/*
 * HandleEvent - callback function for thread end event    
 */
void 
CObjAllocEvent::HandleEvent(SHeapEventData &data)
{
    /*Thread id may be invalid. It's introduced by fixing bug 241085.*/
    //LOG_ASSERT((data.validData & DR_THREAD_ID) != 0);
    LOG_ASSERT((data.validData & DR_OBJECT_ID) != 0);
    LOG_ASSERT((data.validData & DR_OBJECT_INFO) != 0);
    if (m_pProfEnv->ec_env->isAllocSitesSupported()) {
        LOG_ASSERT((data.validData & DR_METHOD_ID) != 0);
        LOG_ASSERT((data.validData & DR_ALLOC_VM_INSTRUCTION_OFFSET) != 0);
    }
    // Modified for bug 275321
    //if (!m_pProfEnv->m_profilerIsActive) {
    if (!m_pProfEnv->m_profilerIsActive || NULL == data.pObjectInfo) {
        return;
    }
    m_pProfEnv->CheckClassId(data.pObjectInfo->classId);
    U64 lineNumber = -1;
    if (m_pProfEnv->ec_env->isAllocSitesSupported()) {
        lineNumber = m_pProfEnv->GetLineNumber(data.allocLocation, data.allocMethodId);
    }
    m_pProfEnv->ec_env->PrintObjAllocElement(&data, lineNumber);
}

BitSet 
CObjAllocEvent::EventDataTypes() 
{
    //            if (m_pProfEnv->ec_env->isAllocSitesSupported()) {
    return DR_THREAD_ID | DR_OBJECT_ID | DR_OBJECT_INFO | DR_METHOD_ID | DR_ALLOC_VM_INSTRUCTION_OFFSET;
    //            } else {
    //                return DR_THREAD_ID | DR_OBJECT_ID | DR_OBJECT_INFO;
    //            }
}
