/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ObjAllocEvent.h,v 1.5 2007/03/23 14:04:45 vrybalov Exp $ 
 ************************************************************************/

#ifndef _OBJ_ALLOC_EVENT_H_
#define _OBJ_ALLOC_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace HeapProf {

    // CObjAllocEvent - represents thread end event 
    class CObjAllocEvent : public MPI::IObjectAllocEventObserver
    {
    public:
        // Constructor
        CObjAllocEvent();
        // Destructor
        ~CObjAllocEvent();
        // Initializes internal data and registers thread end event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SHeapEventData &data);

        MPI::BitSet EventDataTypes();

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace HeapProf*/

#endif // _OBJ_ALLOC_EVENT_H_

