/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ObjFreeEvent.cpp,v 1.4 2007/03/23 14:04:45 vrybalov Exp $ 
 ************************************************************************/

#include "ObjFreeEvent.h"

using namespace Martini::BaseProf;
using namespace Martini::HeapProf;
using namespace Martini::MPI;

CObjFreeEvent::CObjFreeEvent(){}
CObjFreeEvent::~CObjFreeEvent(){}

/*
 * Init - initializes internal data and registers for thread end event    
 */
TResult 
CObjFreeEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    return profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
}

/*
 * HandleEvent - callback function for thread end event    
 */
void 
CObjFreeEvent::HandleEvent(SHeapEventData &data)
{
    LOG_ASSERT((data.validData & DR_OBJECT_AGE) != 0);
    LOG_ASSERT((data.validData & DR_OBJECT_ID) != 0);
    if (!m_pProfEnv->m_profilerIsActive) {
        return;
    }
    m_pProfEnv->ec_env->PrintObjFreeElement(&data);
}
