/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ObjFreeEvent.h,v 1.2 2007/03/23 14:04:45 vrybalov Exp $ 
 ************************************************************************/

#ifndef _OBJ_FREE_EVENT_H_
#define _OBJ_FREE_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace HeapProf {

    // CObjFreeEvent - represents thread end event 
    class CObjFreeEvent : public MPI::IObjectFreeEventObserver
    {
    public:
        // Constructor
        CObjFreeEvent();
        // Destructor
        ~CObjFreeEvent();
        // Initializes internal data and registers thread end event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SHeapEventData &data);

        MPI::BitSet EventDataTypes() {
            return MPI::DR_THREAD_ID | MPI::DR_OBJECT_ID;
        }

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace HeapProf*/

#endif // _OBJ_FREE_EVENT_H_

