/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ThreadEndEvent.cpp,v 1.6 2008/02/28 02:20:31 jkubasta Exp $ 
 ************************************************************************/

#include "ThreadEndEvent.h"

using namespace Martini::HeapProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;

CThreadEndEvent::CThreadEndEvent(){}
CThreadEndEvent::~CThreadEndEvent(){}

/*
 * Init - initializes internal data and registers for thread end event    
 */
TResult 
CThreadEndEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    return profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
}

/*
 * HandleEvent - callback function for thread end event    
 */
void 
CThreadEndEvent::HandleEvent(SThreadEventData &data)
{
    if ((data.validData & DR_THREAD_ID) != 0) {
        if (!m_pProfEnv->m_profilerIsActive) {
            m_pProfEnv->StoreThreadEvent(data.threadId, THREAD_END_EVENT, &data, 0);
            return;
        }
        m_pProfEnv->ec_env->PrintThreadEndElement(data.threadId);
    } 
    else {
        // Invalid thread id
        m_pProfEnv->m_pMpiApi->MessageLog(m_pProfEnv->m_clientId, MT_INFORMATIVE, 
            MD_LOG_FILE, "[HeapProf] Thread End event received without a thread id. "
            "Ignoring event");
    }
}
