/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ThreadStartEvent.cpp,v 1.8 2008/02/28 02:20:31 jkubasta Exp $ 
 ************************************************************************/

#include "ThreadStartEvent.h"

using namespace Martini::HeapProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;

CThreadStartEvent::CThreadStartEvent(){}
CThreadStartEvent::~CThreadStartEvent(){}

/*
 * Init - initializes internal data and registers for thread start event    
 */
TResult 
CThreadStartEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    return profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
}

/*
 * HandleEvent - callback function for thread start event    
 */
void 
CThreadStartEvent::HandleEvent(SThreadEventData &data)
{
    LOG_ASSERT(data.validData == DR_THREAD_ID);
    // request thread information
    SThreadInfo threadInfo;
    TResult iRes = m_pProfEnv->GetThreadInfo(m_pProfEnv->m_clientId, data.threadId, 
            DR_THREAD_INFO, &threadInfo);
    if (iRes != MRTE_RESULT_OK) {
        LOG_TRACE("Thread start event (GetThreadInfo wrong phase)");
        return;
    }

    if (!m_pProfEnv->m_profilerIsActive) {
        m_pProfEnv->StoreThreadEvent(data.threadId, THREAD_START_EVENT, &threadInfo, 0);
        return;
    }

    m_pProfEnv->ec_env->PrintThreadStartElement(data.threadId, 0, &threadInfo);
}
