/************************************************************************
 * Copyright (c) 2005 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ECCallbacks.cpp,v 1.3 2007/03/23 14:04:44 vrybalov Exp $  
 ************************************************************************/

#include "ECCallbacks.h"

using namespace Martini::ExternalControl;
using namespace Martini::JPIAgent;

int 
CEC_Callbacks::RegisterMartiniCallback_(ECommand command, UCallback callback)
{
    switch(command) {
    case CMD_CONFIGURE:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: CMD_CONFIGURE");
        if (m_bWasConfigure) {
            LOG_ERROR("EC JPIAgent RegisterMartiniCallback: CMD_CONFIGURE Error\n");
            return 0;
        }
        m_pConfigure = callback;
        m_bWasConfigure = true;
        break;
    case CMD_START:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: CMD_START");
        if (m_bWasStart) {
            return 0;
        }
        m_pStart = callback;
        m_bWasStart = true;
        break;
    case CMD_STOP:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: CMD_STOP");
        if (m_bWasStop) {
            return 0;
        }
        m_pStop = callback;
        m_bWasStop = true;
        break;
    case CMD_ATTACH:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: CMD_ATTACH");
        if (m_bWasAttach) {
            return 0;
        }
        m_pAttach = callback;
        m_bWasAttach = true;
        break;
    case CMD_DETACH:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: CMD_DETACH");
        if (m_bWasDetach) {
            return 0;
        }
        m_pDetach = callback;
        m_bWasDetach = true;
        break;
    case CMD_RELOAD_OPTIONS:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: CMD_RELOAD_OPTIONS");
        if (m_bWasReloadOptions) {
            return 0;
        }
        m_pReloadOptions = callback;
        m_bWasReloadOptions = true;
        break;
    case CMD_CUSTOM:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: CMD_CUSTOM");
        if (m_bWasCustomCommand) {
            return 0;
        }
        m_pCustomCommand = callback;
        m_bWasCustomCommand = true;
        break;
    default:
        LOG_TRACE("EC JPIAgent RegisterMartiniCallback: default\n");
        break;
    }

    return 1;
}
