/************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ECCallbacks.h,v 1.4 2010/08/17 16:29:59 jwest Exp $ 
 ************************************************************************/

#ifndef __EC_CALLBACKS_H__
#define __EC_CALLBACKS_H__

#include <stdio.h>
#include <stdlib.h>

#include "MartiniExternalControl.h"
#include "log.h"

namespace Martini { namespace JPIAgent {

class CEC_Callbacks {
private:
    bool m_bWasConfigure;
    ExternalControl::UCallback m_pConfigure;
    bool m_bWasStart;
    ExternalControl::UCallback m_pStart;
    bool m_bWasStop;
    ExternalControl::UCallback m_pStop;
    bool m_bWasAttach;
    ExternalControl::UCallback m_pAttach;
    bool m_bWasDetach;
    ExternalControl::UCallback m_pDetach;
    bool m_bWasReloadOptions;
    ExternalControl::UCallback m_pReloadOptions;
    bool m_bWasCustomCommand;
    ExternalControl::UCallback m_pCustomCommand;

public:
    CEC_Callbacks():
    m_bWasConfigure(false),
    m_bWasStart(false),
    m_bWasStop(false),
    m_bWasAttach(false),
    m_bWasDetach(false), 
    m_bWasReloadOptions(false),
    m_bWasCustomCommand(false)
    {
    }

    int RegisterMartiniCallback_(ExternalControl::ECommand command, ExternalControl::UCallback callback);

    void Start() {
        LOG_ASSERT(m_pStart.pfnStart != 0);
        (m_pStart.pfnStart)();
    }

    void Stop() {
        if (m_pStop.pfnStop != 0) {
            (m_pStop.pfnStop)();
        } else {
            LOG_ERROR("Stop callback is not available");
        }
    }

    void Detach() {
        if (m_pDetach.pfnDetach != 0) {
            (m_pDetach.pfnDetach)();
        } else {
            LOG_ERROR("Detach callback is not available");
        }
    }

    void Attach() {
        if (m_pAttach.pfnAttach != 0) {
            (m_pAttach.pfnAttach)();
        } else {
            LOG_ERROR("Attach callback is not available");
        }
    }

    void CustomCommand(unsigned int commandId, void* pData) {
        if (m_pCustomCommand.pfnCustomCommand != 0) {
            (m_pCustomCommand.pfnCustomCommand)(commandId, pData);
        } else {
            LOG_TRACE("EC Custom Command callback is not available");
        }
    }

    bool ProfCallbacksAvailable() {
        return m_bWasStart && m_bWasStop && m_bWasAttach && m_bWasDetach;  //TODO Add m_bWasCustomCommand?
    }

};

} /* namespace Martini */ } /*namespace JPIAgent*/

#endif // __EC_CALLBACKS_H__
