/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ECDefs.h,v 1.9 2009/07/10 00:29:36 jwest Exp $ 
 ***********************************************************************/

#ifndef __DEFS_H__
#define __DEFS_H__

//#ifdef _JVMPI__ASYNCRONOUS_IO
#ifdef _WIN32
#include <WinSock2.h>
// #include <windows.h>
#elif _AIX

#else
 #include <aio.h>
 #include <sys/stat.h>
#endif
//#endif

#define tptp_free free //TODO

/**
  * Macros/typedefs to ease the readability of multiplatform code.
  */
#ifdef _WIN32                                        /* Win32 */
 typedef DWORD PID;
 typedef HANDLE RA_HANDLE;
 #define RA_HANDLE_0    0
 #define CLOSE_RA_HANDLE(handle)        CloseHandle(handle)
#else                                                /* else */
 typedef pid_t PID;
typedef int RA_HANDLE;
 #define RA_HANDLE_0 0
 #define CLOSE_RA_HANDLE(handle)        close(handle)
 
 typedef int BOOL;
 #ifndef TRUE
   #define TRUE 1
 #endif
 #ifndef FALSE
   #define FALSE 0
 #endif
 #include <unistd.h>
#endif

#include "utility.h"
#include "Performance.h"

#endif //__DEFS_H__
