/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ECJvmtiAgent.h,v 1.12 2010/08/17 16:29:59 jwest Exp $ 
 ***********************************************************************/

#ifndef MRTE_ECJVMTIAGENT_H
#define MRTE_ECJVMTIAGENT_H

#include "MartiniExternalControl.h"
#include "Options.h"
#include "Filters.h"
#include "PrintWrapper.h"
#include "ECWrapper.h"
#include "ACC_Env.h"
#include "log.h"
#include "ECCallbacks.h"
#include "PrintXML.h"

namespace Martini { namespace JPIAgent {

class CECJvmtiAgent
{
public:
    static CECJvmtiAgent& GetInstance();

    int RegisterMartiniCallback(Martini::ExternalControl::ECommand command, Martini::ExternalControl::UCallback callback);
    void MartiniMessage(char* szMsg, Martini::ExternalControl::ESeverityLevel level);
    void MartiniProcessShutdown();
    TResult EC_Init(char **szWorkingDir, const char *szOptions);

    COptions GetOptions() {return m_Options; };
    Options GetOptionsStruct() {return m_Options.m_jvmtiAgent_Options; };

    CFilters* getCFilters() 
    {
        return &m_Filters;
    }

    COptions* getCOptions() 
    {
        return &m_Options;
    }

    ~CECJvmtiAgent();

private:
    // private constructor. Use GetInstance() to obtain the singleton instance
    CECJvmtiAgent();

    COptions m_Options;
    CFilters m_Filters;
    CPrintWrapper *m_Print;
    ECWrapper m_ECWrapper;
    CEC_Callbacks m_Callbacks;
};

} /* namespace Martini */ } /*namespace JPIAgent*/

#endif // MRTE_ECJVMTIAGENT_H
