/*******************************************************************************
 * Copyright (c) 2005 - 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ECWrapper.h,v 1.14 2008/03/24 15:38:06 aalexeev Exp $ 
 ***********************************************************************/

#ifndef __ECWrapper_H__
#define __ECWrapper_H__

#include "PrintWrapper.h"
#include "ECDefs.h"
#include "EC_Env.h"
#include "ACC_Env.h"
#include "ECCallbacks.h"

namespace Martini { namespace JPIAgent {

class CPrint;
class CFilters;
class COptions;

class ECWrapper
{
public:
    ECWrapper(CPrintWrapper* pCPrint, CFilters* pCFilters, COptions* pCOptions);
    ~ECWrapper(void);

    void InitACCollector();
	void RegisterMartiniCallbacks(CEC_Callbacks* callbacks);
	
//protected:
    static CPrintWrapper* m_pCPrint;
    static CFilters* m_pCFilters;
    static COptions* m_pCOptions;
    static CEC_Callbacks* m_pCallbacks;

    static Martini::JPIAgent::ECFunctions_ m_ECFunctions;
    static Martini::JPIAgent::EC_Env m_EC_Env;

    static char* m_profName;

    static bool m_VMInitDone;
    static Martini::ACCollector::ACCollector_SendVMAgentInitialized_t m_SendVMAgentInitializedCommand;

protected:
    Martini::ACCollector::ACC_ENV* PrepareACCEnv();
    void BindJpiFunctions();
};

} /* namespace Martini */ } /*namespace JPIAgent*/

#endif // __ECWrapper_H__
