/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: Performance.h,v 1.15 2009/11/21 22:23:16 jwest Exp $ 
 ***********************************************************************/

#ifndef _PERFORMANCE_H_
#define _PERFORMANCE_H_

#include "MpiAPI.h"

#if defined __cplusplus
 extern "C" {
#endif

#include "ECDefs.h"

#if defined(__linux__) || defined(MVS)
 #include <stdint.h>
 #define _inline inline
#elif defined(_SOLARIS) || defined(_SOLARISX86) || defined(_AIX)
 #define _inline inline
#endif

/** The goal of this file is to define some inline performance code
  * for doing metrics on each of the processors supported.
  */
//typedef U64 timestamp_t;
extern double _startTimeAsDouble;
extern U64 _startTimeNanosec;

static _inline double nanosToTime(U64 timestampInNanoSeconds, BOOL asInterval) {
#ifdef _WIN32
    double timestamp = (double)((__int64)timestampInNanoSeconds);
#else
    double timestamp = timestampInNanoSeconds;
#endif

    if(asInterval) {
        return timestamp/1000000000.;
    } else {
        return timestamp/1000000000. + _startTimeAsDouble;
    }
}

/** COLLECT_START_TIME_INFORMATION  *******************************************
  * Initialization routine for future use.
  * This routine records the time at which this function was called and uses
  * this time to determine what the current time is.
  */
extern void jvmtiAgent_collectStartTimeInformation();

/** GET_PROCESS_START_TIME  ***************************************************
  *  Returns the start time of the current process in nanoseconds.
  */
extern U64 jvmtiAgent_getProcessStartTime();

/** GET_TIMEZONE  *************************************************************
  * Returns the current timezone as an offset, in minutes, working westward from
  * GMT.  ie.  GMT+5  would be 300 as there are 300 minutes in 5 hours.
  */
extern unsigned long jvmtiAgent_getTimezone();

/**
  * Initializes time counting. Must be invoked first.
  * 
  * @return 0 - Initialization is successful.
  * @return -1 - Initialization failed.
  */
extern int InitProfilerTimer();
    
/**
  * Retrieves time value in nanoseconds since time counting initialization
  * Precision is platform depended.
  *
  * Returns a 64 bit unsigned integer containing nanoseconds since time counting initialization.
  * Returns 0 - function failed.
  * 
  */
extern U64 GetProfilerTime();

#if defined __cplusplus
}
#endif

#endif
