/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: Print.h,v 1.27 2009/11/21 22:23:16 jwest Exp $ 
 ***********************************************************************/

#ifndef __PRINT_H__
#define __PRINT_H__

#include "MpiAPI.h"
#include "ECDefs.h"
#include "ACC_Env.h"
#include "OSA.h"

#include "InStructs.h"

#if defined(_AIX) || defined(_SOLARIS) || defined(_SOLARISX86)
	#include <sys/types.h>
	#include <sys/stat.h>
	#include <fcntl.h>
#endif


#define AGENT_VERSION "2.000"

namespace Martini { namespace JPIAgent {

/* The size of the CElementBuffer buffer for IO */
#define ORIGINAL_MESSAGE_BUFFER_SIZE 1024

    class CElementBuffer
    {
    public:
        CElementBuffer(bool is_binary = false);
        ~CElementBuffer();

        void AddString(const char *src);
        void AddChar(const char chr) ;
        void MemCpy(const void *src, size_t count);
		bool IsBinary() { return binary; };
		void *AllocBuffer(size_t size);

        char *buffer;
        size_t offset;

    private:
        int m_REALLOCATED_BUFFER_SIZE;
		bool binary;
        void CheckMemorySize(size_t in_value);
    };

    class COptions;
    class CFilters;
    class Filter;

    using namespace Martini::MPI;

    class CPrint
    {
    public:
        // constructor
        CPrint(COptions* pCOptions, CFilters* pCFilters);
        // destructor
        ~CPrint();

        virtual void InitializeStandaloneIO(const char *fileName);
        virtual void CleanupStandaloneIO();
		virtual void setSendDataFunc(Martini::ACCollector::ACCollector_SendData_t pfSendData);
		virtual Martini::ACCollector::ACCollector_SendData_t getSendDataFunc();

        void jvmtiAgent_print(CElementBuffer *pElB);

        virtual void start();
        virtual void stop();
        virtual void suspend();
        virtual void resume();
        virtual bool isStarted();
        virtual bool isSuspended();

		void setDumpMode(bool dumpMode);

        virtual void PrintStartingFragments() = 0;

        virtual void printNodeElement() = 0;
        virtual void printProcessCreateElement() = 0;
        virtual void printAgentCreateElement(char *options) = 0;
        virtual void printTraceStartElement(char *options) = 0;
        virtual void printTraceEndElement() = 0;
        virtual void printAgentDestroyElement() = 0;
        virtual void printNewMethodElement(TId methodId, SMethodInfo* methodInfo) = 0;
        virtual void printNewClassElement(TId classId, SClassInfo* classInfo) = 0;
        virtual void printMethodEntryElement(TId threadId, TId methodId, TId classId, unsigned long ticket, unsigned long stackDepth) = 0;
        virtual void printAgMethodEntryElement(TId threadId, TId methodId, U64 baseTime, U64 minTime, U64 maxTime, U64 baseCPUTime, U64 numCalls) = 0;
        virtual void printMethodExitElement(TId threadId, TId methodId, TId classId, unsigned long ticket, U64 cpuTime) = 0;
        virtual void printAgMethodExitElement(TId threadId, TId methodId) = 0;
        virtual void printThreadStartElement(TId threadId, TId objectId, SThreadInfo* threadInfo) = 0;
        virtual void printThreadEndElement(TId threadId) = 0;
        virtual void printJvmInitDoneElement(TId threadId) = 0;
        virtual void printJvmShutdownElement() = 0;

        virtual void printObjAllocElement(SHeapEventData* heapData, U64 lineNumber) = 0;
        virtual void printObjFreeElement(SHeapEventData* heapData) = 0;
        virtual void printGcStartElement() = 0;
        virtual void printGcFinishElement() = 0;
        virtual void printHDStartElement(TId heapDumpId, char* heapDefName, U64 basetime) = 0;
        virtual void printGcRootElement(TId heapDumpIdRef, TId objIdRef, EObjectReferenceType type) = 0;
        virtual void printObjectReferenceElement(TId heapDumpIdRef, SObjectReference* objRef) = 0;

        virtual void printMonitorWaitElement(SMonitorWaitEventData* monitorWaitData/*int isThreadSleep*/, SStackTrace_* stackTrace) = 0;  //TODO
        virtual void printMonitorWaitedElement(SMonitorWaitedEventData* monitorWaitedData, U64 timeout, SStackTrace_* stackTrace) = 0;
        virtual void printMonitorContendedEnterElement(SContendedMonitorEnterEventData* conMonEnterData, SStackTrace_* stackTrace) = 0;
        virtual void printMonitorContendedEnteredElement(SContendedMonitorEnteredEventData* conMonEnteredData, SStackTrace_* stackTrace) = 0;
        virtual void printThreadInteractionElements(SThreadInteractionEventData* threadInteractionData, SStackTrace_* stackTrace) = 0;

        virtual void printCustomElement(const char *str) = 0;

        virtual void PrintOption(const char *key, const char *value) = 0;
        virtual void printFilter(Filter *filter) = 0;

    private:
        bool m_jvmtiAgent_suspendIO;
        Martini::ACCollector::ACCollector_SendData_t m_pfSendData;
        RA_HANDLE m_jvmtiAgent_outFile;        /* The output file */
//#ifndef _WIN32
        Martini::OSA::IThreadSync* m_lockObject;
//#endif

    protected:
        CPrint();

        COptions* m_pOptions;
        CFilters* m_pCFilters;
        bool printingStarted;
		bool m_dumpMode;

        char* FormatName(const char *name);

        char* GenerateUUID();
        char* GetRANodeUUID();
        char* GetRATraceUUID();
        char* GetRAProcessUUID();
        char* GetRAAgentUUID();
        PID GetRAProcessId();
		char* ConvertClassName(const char *inbuf);
		char* GetHostname();
		char* GetIPAddress();

    }; // class CPrint

} /* namespace Martini */ } /*namespace JPIAgent*/

#endif // __PRINT_H__
