/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * $Id: PrintBinary.h,v 1.2 2008/03/24 23:26:18 jkubasta Exp $
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Stanislav Polevic, Intel - Initial API and implementation
 *
 ***********************************************************************/

#ifndef __PRINT_BINARY_H__
#define __PRINT_BINARY_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Print.h"
#include "binformat.h"

namespace Martini { namespace JPIAgent {

	using namespace Martini::MPI;

	class CPrintBinary : public CPrint  
	{
	public:
		CPrintBinary(COptions* pCOptions, CFilters* pCFilters);
		virtual ~CPrintBinary();

	public:
			void PrintStartingFragments();

			void PrintEncodingMessage();
			void PrintFrequencyMessage();

			void printNodeElement();
			void printProcessCreateElement();
			void printAgentCreateElement(char *options);
			void printTraceStartElement(char *options);
			void printTraceEndElement();
			void printAgentDestroyElement();
			void printNewMethodElement(TId methodId, SMethodInfo* methodInfo);
			void printMethodEntryElement(TId threadId, TId methodId, TId classId, unsigned long ticket, unsigned long stackDepth);
			void printAgMethodEntryElement(TId threadId, TId methodId, U64 baseTime, U64 minTime, U64 maxTime, U64 baseCPUTime, U64 numCalls);
			void printMethodExitElement(TId threadId, TId methodId, TId classId, unsigned long ticket, U64 cpuTime);
			void printAgMethodExitElement(TId threadId, TId methodId);
			void printThreadStartElement(TId threadId, TId objectId, SThreadInfo* threadInfo);
			void printThreadEndElement(TId threadId);
			void printJvmInitDoneElement(TId threadId);
			void printJvmShutdownElement();
			void printNewClassElement(TId classId, SClassInfo* classInfo);

			void printObjAllocElement(SHeapEventData* heapData, U64 lineNumber);
			void printObjFreeElement(SHeapEventData* heapData);
			void printGcStartElement();
			void printGcFinishElement();
			void printHDStartElement(TId heapDumpId, char* heapDefName, U64 basetime);
			void printGcRootElement(TId heapDumpIdRef, TId objIdRef, EObjectReferenceType type);
			void printObjectReferenceElement(TId heapDumpIdRef, SObjectReference* objRef);

			void printMonitorWaitElement(SMonitorWaitEventData* monitorWaitData/*int isThreadSleep*/, SStackTrace_* stackTrace);  //TODO
			void printMonitorWaitedElement(SMonitorWaitedEventData* monitorWaitedData, U64 timeout, SStackTrace_* stackTrace);
			void printMonitorContendedEnterElement(SContendedMonitorEnterEventData* conMonEnterData, SStackTrace_* stackTrace);
			void printMonitorContendedEnteredElement(SContendedMonitorEnteredEventData* conMonEnteredData, SStackTrace_* stackTrace);
	        void printThreadInteractionElements(SThreadInteractionEventData* threadInteractionData, SStackTrace_* stackTrace);

			void PrintOption(const char *key, const char *value);
			void printFilter(Filter *filter);

			void printCustomElement(const char *str);

	protected:
			void printFormatHeader(bool force_print);
			void printMessage(CBinaryMessage *msg, CElementBuffer *elb);
			U64 getTimestamp(U64 time = GetProfilerTime());
			U64 getInterval(U64 interval = GetProfilerTime());
	private:
	        void AppendAnnotations(bf_string_t methods[], bf_long_t lines[], size_t *length, SStackTrace_* stackTrace);


	};

} /* namespace Martini */ } /*namespace JPIAgent*/

#endif 
