/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Stanislav Polevic, Intel - Initial API and implementation
 *
 * $Id: PrintWrapper.cpp,v 1.3 2008/03/31 18:56:31 aalexeev Exp $ 
 ***********************************************************************/


#include "PrintWrapper.h"

using namespace Martini::MPI;
using namespace Martini::JPIAgent;

CPrintWrapper::CPrintWrapper(COptions* pCOptions, CFilters* pCFilters): m_xmlPrinter(pCOptions, pCFilters),
																		m_binaryPrinter(pCOptions, pCFilters),
																		m_dumpXmlPrinter(pCOptions, pCFilters)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		m_printer[i] = NULL;
	}
	setOutputFormat(XmlFormat);
	m_dumpXmlPrinter.setDumpMode(true);
}

CPrintWrapper::~CPrintWrapper()
{
}

void 
CPrintWrapper::setXmlDumpFile(const char *name) 
{
	m_dumpXmlPrinter.InitializeStandaloneIO(name);
	m_printer[1] = &m_dumpXmlPrinter;
}


/* Do not change printers after InitializeStandaloneIO() has been called */
void
CPrintWrapper::setOutputFormat(enum TraceFormat format)
{
	switch(format) {
	case XmlFormat:
		m_printer[0] = &m_xmlPrinter;
		break;
	case BinaryFormat:
		m_printer[0] = &m_binaryPrinter;
		break;
	default:
		m_printer[0] = &m_xmlPrinter;
	};
}

void 
CPrintWrapper::start()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->start();
	}
}

void 
CPrintWrapper::stop()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->stop();
	}
}

void 
CPrintWrapper::suspend()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->suspend();
	}
}

void 
CPrintWrapper::resume()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->resume();
	}
}

bool 
CPrintWrapper::isStarted()
{
	return (m_printer[0]->isStarted());
}

bool 
CPrintWrapper::isSuspended()
{
	return (m_printer[0]->isSuspended());
}


void
CPrintWrapper::setSendDataFunc(Martini::ACCollector::ACCollector_SendData_t pfSendData)
{
	m_xmlPrinter.setSendDataFunc(pfSendData);
	m_binaryPrinter.setSendDataFunc(pfSendData);
}

Martini::ACCollector::ACCollector_SendData_t
CPrintWrapper::getSendDataFunc()
{
	return m_printer[0]->getSendDataFunc();
}

void
CPrintWrapper::InitializeStandaloneIO(const char *fileName)
{
	m_printer[0]->InitializeStandaloneIO(fileName);
}

void
CPrintWrapper::CleanupStandaloneIO()
{
	m_printer[0]->CleanupStandaloneIO();
}

void 
CPrintWrapper::PrintStartingFragments()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->PrintStartingFragments();
	}
}

void 
CPrintWrapper::printNodeElement()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printNodeElement();
	}
}

void 
CPrintWrapper::printProcessCreateElement()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printProcessCreateElement();
	}
}

void 
CPrintWrapper::printAgentCreateElement(char *options)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printAgentCreateElement(options);
	}
}

void 
CPrintWrapper::printTraceStartElement(char *options)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printTraceStartElement(options);
	}
}

void 
CPrintWrapper::printTraceEndElement()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printTraceEndElement();
	}
}

void 
CPrintWrapper::printAgentDestroyElement()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printAgentDestroyElement();
	}
}

void 
CPrintWrapper::printNewMethodElement(TId methodId, SMethodInfo* methodInfo)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printNewMethodElement(methodId, methodInfo);
	}
}

void 
CPrintWrapper::printMethodEntryElement(TId threadId, TId methodId, TId classId, unsigned long ticket, unsigned long stackDepth)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printMethodEntryElement(threadId, methodId, classId, ticket, stackDepth);
	}
}

void 
CPrintWrapper::printAgMethodEntryElement(TId threadId, TId methodId, U64 baseTime, U64 minTime, U64 maxTime, U64 baseCPUTime, U64 numCalls)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printAgMethodEntryElement(threadId, methodId, baseTime, minTime, maxTime, baseCPUTime, numCalls);
	}
}

void 
CPrintWrapper::printMethodExitElement(TId threadId, TId methodId, TId classId, unsigned long ticket, U64 cpuTime)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printMethodExitElement(threadId, methodId, classId, ticket, cpuTime);
	}
}

void 
CPrintWrapper::printAgMethodExitElement(TId threadId, TId methodId)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printAgMethodExitElement(threadId, methodId);
	}
}

void 
CPrintWrapper::printThreadStartElement(TId threadId, TId objectId, SThreadInfo* threadInfo)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printThreadStartElement(threadId, objectId, threadInfo);
	}
}

void 
CPrintWrapper::printThreadEndElement(TId threadId)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printThreadEndElement(threadId);
	}
}

void 
CPrintWrapper::printJvmInitDoneElement(TId threadId)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printJvmInitDoneElement(threadId);
	}
}

void 
CPrintWrapper::printJvmShutdownElement()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printJvmShutdownElement();
	}
}

void 
CPrintWrapper::printNewClassElement(TId classId, SClassInfo* classInfo)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printNewClassElement(classId, classInfo);
	}
}

void 
CPrintWrapper::printObjAllocElement(SHeapEventData* heapData, U64 lineNumber)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printObjAllocElement(heapData, lineNumber);
	}
}

void 
CPrintWrapper::printObjFreeElement(SHeapEventData* heapData)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printObjFreeElement(heapData);
	}
}

void 
CPrintWrapper::printGcStartElement()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printGcStartElement();
	}
}

void 
CPrintWrapper::printGcFinishElement()
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printGcFinishElement();
	}
}

void 
CPrintWrapper::printHDStartElement(TId heapDumpId, char* heapDefName, U64 basetime)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printHDStartElement(heapDumpId, heapDefName, basetime);
	}
}

void 
CPrintWrapper::printGcRootElement(TId heapDumpIdRef, TId objIdRef, EObjectReferenceType type)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printGcRootElement(heapDumpIdRef, objIdRef, type);
	}
}

void 
CPrintWrapper::printObjectReferenceElement(TId heapDumpIdRef, SObjectReference* objRef)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printObjectReferenceElement(heapDumpIdRef, objRef);
	}
}

void 
CPrintWrapper::printMonitorWaitElement(SMonitorWaitEventData* monitorWaitData/*int isThreadSleep*/, SStackTrace_* stackTrace)  //TODO
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printMonitorWaitElement(monitorWaitData, stackTrace);
	}
}

void 
CPrintWrapper::printMonitorWaitedElement(SMonitorWaitedEventData* monitorWaitedData, U64 timeout, SStackTrace_* stackTrace)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printMonitorWaitedElement(monitorWaitedData, timeout, stackTrace);
	}
}

void 
CPrintWrapper::printMonitorContendedEnterElement(SContendedMonitorEnterEventData* conMonEnterData, SStackTrace_* stackTrace)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printMonitorContendedEnterElement(conMonEnterData, stackTrace);
	}
}

void 
CPrintWrapper::printMonitorContendedEnteredElement(SContendedMonitorEnteredEventData* conMonEnteredData, SStackTrace_* stackTrace)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printMonitorContendedEnteredElement(conMonEnteredData, stackTrace);
	}
}

void 
CPrintWrapper::printThreadInteractionElements(SThreadInteractionEventData* threadInteractionData, SStackTrace_* stackTrace)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printThreadInteractionElements(threadInteractionData, stackTrace);
	}
}

void 
CPrintWrapper::printCustomElement(const char *str)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printCustomElement(str);
	}
}

void 
CPrintWrapper::PrintOption(const char *key, const char *value)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->PrintOption(key, value);
	}
}

void 
CPrintWrapper::printFilter(Filter *filter)
{
	for (int i = 0; i < PRINTER_SIZE; ++i) {
		if (m_printer[i] == NULL) continue;
		m_printer[i]->printFilter(filter);
	}
}
