/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Stanislav Polevic, Intel - Initial API and implementation
 *
 * $Id: PrintWrapper.h,v 1.3 2008/03/31 18:56:31 aalexeev Exp $ 
 ***********************************************************************/

#ifndef __PRINT_WRAPPER_H__
#define __PRINT_WRAPPER_H__

#include "Print.h"
#include "Options.h"
#include "Filters.h"
#include "strings.h"
#include "log.h"
#include "PrintXML.h"
#include "PrintBinary.h"

namespace Martini { namespace JPIAgent {

    using namespace Martini::MPI;

#define PRINTER_SIZE 2

    class CPrintWrapper: public CPrint
    {

		CPrintXML m_xmlPrinter;
		CPrintBinary m_binaryPrinter;
		CPrintXML m_dumpXmlPrinter;
		CPrint *m_printer[PRINTER_SIZE];

    public:
        // constructor
        CPrintWrapper(COptions* pCOptions, CFilters* pCFilters);
        // destructor
        ~CPrintWrapper();

		void setXmlDumpFile(const char *name);
		void setOutputFormat(enum TraceFormat format);

        void InitializeStandaloneIO(const char *fileName);
        void CleanupStandaloneIO();
		void setSendDataFunc(Martini::ACCollector::ACCollector_SendData_t pfSendData);
		Martini::ACCollector::ACCollector_SendData_t getSendDataFunc();

        void start();
        void stop();
        void suspend();
        void resume();
        bool isStarted();
        bool isSuspended();

        void PrintStartingFragments();

        void printNodeElement();
        void printProcessCreateElement();
        void printAgentCreateElement(char *options);
        void printTraceStartElement(char *options);
        void printTraceEndElement();
        void printAgentDestroyElement();
        void printNewMethodElement(TId methodId, SMethodInfo* methodInfo);
        void printMethodEntryElement(TId threadId, TId methodId, TId classId, unsigned long ticket, unsigned long stackDepth);
        void printAgMethodEntryElement(TId threadId, TId methodId, U64 baseTime, U64 minTime, U64 maxTime, U64 baseCPUTime, U64 numCalls);
        void printMethodExitElement(TId threadId, TId methodId, TId classId, unsigned long ticket, U64 cpuTime);
        void printAgMethodExitElement(TId threadId, TId methodId);
        void printThreadStartElement(TId threadId, TId objectId, SThreadInfo* threadInfo);
        void printThreadEndElement(TId threadId);
        void printJvmInitDoneElement(TId threadId);
        void printJvmShutdownElement();
        void printNewClassElement(TId classId, SClassInfo* classInfo);

        void printObjAllocElement(SHeapEventData* heapData, U64 lineNumber);
        void printObjFreeElement(SHeapEventData* heapData);
        void printGcStartElement();
        void printGcFinishElement();
        void printHDStartElement(TId heapDumpId, char* heapDefName, U64 basetime);
        void printGcRootElement(TId heapDumpIdRef, TId objIdRef, EObjectReferenceType type);
        void printObjectReferenceElement(TId heapDumpIdRef, SObjectReference* objRef);

        void printMonitorWaitElement(SMonitorWaitEventData* monitorWaitData/*int isThreadSleep*/, SStackTrace_* stackTrace);  //TODO
        void printMonitorWaitedElement(SMonitorWaitedEventData* monitorWaitedData, U64 timeout, SStackTrace_* stackTrace);
        void printMonitorContendedEnterElement(SContendedMonitorEnterEventData* conMonEnterData, SStackTrace_* stackTrace);
        void printMonitorContendedEnteredElement(SContendedMonitorEnteredEventData* conMonEnteredData, SStackTrace_* stackTrace);
        void printThreadInteractionElements(SThreadInteractionEventData* threadInteractionData, SStackTrace_* stackTrace);

        void printCustomElement(const char *str);

        void PrintOption(const char *key, const char *value);
        void printFilter(Filter *filter);

	};

} /* namespace Martini */ } /*namespace JPIAgent*/

#endif // __PRINT_WRAPPER_H__
