/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: PrintXML.h,v 1.18 2008/02/29 19:16:31 jkubasta Exp $ 
 ***********************************************************************/

#ifndef __PRINT_XML_H__
#define __PRINT_XML_H__

#include "Print.h"

namespace Martini { namespace JPIAgent {

    using namespace Martini::MPI;

    class CPrintXML: public CPrint
    {
    public:

        // constructor
        CPrintXML(COptions* pCOptions, CFilters* pCFilters);
        // destructor
        ~CPrintXML();

        void PrintStartingFragments();

        void printXMLStartElement();
        void printStandaloneTraceTagOpen();
        void printStandaloneTraceTagClose();
        void printNodeElement();
        void printProcessCreateElement();
        void printAgentCreateElement(char *options);
        void printTraceStartElement(char *options);
        void printTraceEndElement();
        void printAgentDestroyElement();
        void printNewMethodElement(TId methodId, SMethodInfo* methodInfo);
        void printMethodEntryElement(TId threadId, TId methodId, TId classId, unsigned long ticket, unsigned long stackDepth);
        void printAgMethodEntryElement(TId threadId, TId methodId, U64 baseTime, U64 minTime, U64 maxTime, U64 baseCPUTime, U64 numCalls);
        void printMethodExitElement(TId threadId, TId methodId, TId classId, unsigned long ticket, U64 cpuTime);
        void printAgMethodExitElement(TId threadId, TId methodId);
        void printThreadStartElement(TId threadId, TId objectId, SThreadInfo* threadInfo);
        void printThreadEndElement(TId threadId);
        void printJvmInitDoneElement(TId threadId);
        void printJvmShutdownElement();
        void printNewClassElement(TId classId, SClassInfo* classInfo);

        void printObjAllocElement(SHeapEventData* heapData, U64 lineNumber);
        void printObjFreeElement(SHeapEventData* heapData);
        void printGcStartElement();
        void printGcFinishElement();
        void printHDStartElement(TId heapDumpId, char* heapDefName, U64 basetime);
        void printGcRootElement(TId heapDumpIdRef, TId objIdRef, EObjectReferenceType type);
        void printObjectReferenceElement(TId heapDumpIdRef, SObjectReference* objRef);

        void printMonitorWaitElement(SMonitorWaitEventData* monitorWaitData/*int isThreadSleep*/, SStackTrace_* stackTrace);  //TODO
        void printMonitorWaitedElement(SMonitorWaitedEventData* monitorWaitedData, U64 timeout, SStackTrace_* stackTrace);
        void printMonitorContendedEnterElement(SContendedMonitorEnterEventData* conMonEnterData, SStackTrace_* stackTrace);
        void printMonitorContendedEnteredElement(SContendedMonitorEnteredEventData* conMonEnteredData, SStackTrace_* stackTrace);
        void printThreadInteractionElements(SThreadInteractionEventData* threadInteractionData, SStackTrace_* stackTrace);

        void printCustomElement(const char *str);

        void PrintOption(const char *key, const char *value);
        void printFilter(Filter *filter);

    private:

        void AppendAnnotations(CElementBuffer *pElB, SStackTrace_* stackTrace);
        void AppendElementStart(CElementBuffer *pElB,
            const char *elementName, size_t elementNameLength);
        void AppendHostNameAttribute(CElementBuffer *pElB);
        void AppendIPAddressAttribute(CElementBuffer *pElB);
        void AppendStringAttribute(CElementBuffer *pElB, 
            const char *attributeName, unsigned short attributeNameLength,
            const char *in_value);
        void AppendString(CElementBuffer *pElB, const char *in_value);
        void AppendIntegerAttribute(CElementBuffer *pElB, 
            const char *attributeName,
            unsigned short attributeNameLength,
            int value);
        void AppendInteger64Attribute(CElementBuffer *pElB, 
            const char *attributeName,
            unsigned short attributeNameLength,
            U64 value);
        void AppendLabeledTimestamp(CElementBuffer *pElB, const char *attributeName,
            unsigned short attributeNameLength, U64 time, BOOL asInterval);
        void AppendTimeStamp(CElementBuffer *pElB, U64 time);
        void AppendCurrentTimeStamp(CElementBuffer *pElB);
        void AppendOverhead(CElementBuffer *pElB, U64 time);
        void AppendThreadCPUTime(CElementBuffer *pElB, U64 time);
        //    void AppendString(CElementBuffer *pElB, const char *value);
        void AppendElementEnd(CElementBuffer *pElB, const char *elementName, 
            unsigned short elementNameLength);
        void AppendElementEnd2(CElementBuffer *pElB);
        void AppendClosingTag(CElementBuffer *pElB, const char *eventName,
            unsigned short eventNameLength);
        void AppendEmptyEventHeader(CElementBuffer *pElB, TId threadId,
            const char *eventName, unsigned short eventNameLength);
        void AppendEmptyEventHeader1(CElementBuffer *pElB, TId threadId,
            const char *eventName, unsigned short eventNameLength);
        void AppendTicketAttribute(CElementBuffer *pElB, unsigned long ticket);
        void AppendStackDepthAttribute(CElementBuffer *pElB, unsigned long stackDepth);

//        void AppendTraceIdRefAttribute(CElementBuffer *pElB);
//        void AppendListInteger(CElementBuffer *pElB, int value);
        void AppendUnsignedLongAttribute(CElementBuffer *pElB, const char *attributeName, 
            unsigned short attributeNameLength, unsigned long value);

        char* StripControls(const unsigned char *inbuf, unsigned char **outBuf);
        char* Escape_for_xml(const char *inbuf, char **outbuf);

        char* ConvertClassName(const char *inbuf);

    }; // class CPrint

} /* namespace Martini */ } /*namespace JPIAgent*/

#endif // __PRINT_XML_H__
