/*******************************************************************************
 * Copyright (c) 2008, 2009 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * $Id: Profiler.c,v 1.5 2009/09/10 21:17:34 jcayne Exp $ 
 ***********************************************************************/

#include "Profiler.h"

extern void appStartTracing();		// defined in ECWrapper.cpp
extern void appStopTracing();
extern int isProfilerApiEnabled();
extern int runGC();
extern void printCustomElement(const char* str);

JNIEXPORT jint JNICALL Java_org_eclipse_tptp_profiler_Profiler_initialize0
  (JNIEnv *env, jobject thisObj) {
  
  	return isProfilerApiEnabled() ? 0 : -1;
  }

/*
 * Class:     org_eclipse_tptp_profiler_Profiler
 * Method:    startProfiling0
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_eclipse_tptp_profiler_Profiler_startProfiling0
  (JNIEnv *env, jobject thisObj) {

  	appStartTracing();
  
  	return 0;
  }

/*
 * Class:     org_eclipse_tptp_profiler_Profiler
 * Method:    stopProfiling0
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_eclipse_tptp_profiler_Profiler_stopProfiling0
  (JNIEnv *env, jobject thisObj) {

	if (!isProfilerApiEnabled()) return -1;
  	
	appStopTracing();
  
  	return 0;
  }
  
/*
 * Class:     org_eclipse_tptp_profiler_Profiler
 * Method:    runGC0
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_eclipse_tptp_profiler_Profiler_runGC0
  (JNIEnv *env, jobject thisObj) {

	runGC();
  
  	return 0;
  }
   
 JNIEXPORT void JNICALL Java_org_eclipse_tptp_profiler_Profiler_emitXMLFragment0
  (JNIEnv *env, jobject thisObj, jstring xmlFragment) {
 
 	const char *native = (*env)->GetStringUTFChars(env, xmlFragment, NULL);
 	printCustomElement(native);
	(*env)->ReleaseStringUTFChars(env, xmlFragment, native);
 }
 
