/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: utility.h,v 1.8 2009/11/21 22:23:16 jwest Exp $ 
 ***********************************************************************/

#ifndef __UTILITY_H__
#define __UTILITY_H__ 1

#ifdef __cplusplus
 extern "C" {
#endif

#ifdef _WIN32
    #include <Windows.h>
    #include <Winbase.h>
    #ifndef PATH_MAX
        #define PATH_MAX (10 * _MAX_PATH)
        char *realpath(const char* fileName, char * buf) ;
    #endif
#endif

#ifndef PATH_MAX
#define PATH_MAX 2048
#endif

#if defined(__linux__) || defined(MVS)
 #include <stdint.h>
 #include <stdlib.h>
 #define _inline inline
#endif

#if defined(_SOLARIS)  || defined(_SOLARISX86) || defined(_AIX) || defined(MVS)
	#include <sys/types.h>
#endif

#ifdef _WIN32
    typedef unsigned __int64  Uint64;
#else
    typedef uint64_t Uint64;
#endif

/** CALLOC  *************************************************************
  * Allocate some memory from the heap.  If there is no more memory left
  * the VM will exit gracefully.
  */
extern void* jvmtiAgent_Calloc(size_t size);

/********************************************************
 * strcpyrealloc()
 * 
 * Copy one string to the other, first reallocating the 
 * space pointed to by the destination so that the src
 * can comfortably fit in it. 
 * @param dest pointer to pointer to destination 
 * @param src the source string 
 * @return 0 if successful, -1 otherwise 
 */ 

int strcpyrealloc(char **dest, const char *src); 

/*********************************************************
 * double2string()
 *
 * Take a value of type double and convert it into a string, 
 * using '.' (period) as the decimal symbol (i.e. ignore what
 * the locale setting uses for a decimal place). 
 *
 * The method further assumes val is non-negative. 
 * 
 * @param val the double value to be converted into a string (non-negative value) 
 * @param buffer the buffer into which the string should be put
 * @param offset the offset into the buffer where to start writing
 * @param precision the number of digits to appear after the decimal place
 * @return the offset just past the last written position in buffer
 */ 
unsigned short double2string(double val, char *buffer, unsigned short offset, int precision); 

#ifdef __cplusplus
 }
#endif

#endif
