/*****************************************************************************
 * Copyright (c) 1997-2010, Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __LIBRARY_LOADER_H__
#define __LIBRARY_LOADER_H__

#include "OSA.h"

// Environment variable to be used by MRTE (Java/.NET loaders) to load Martini binaries
#define JAVA_PROFILER_HOME_ENV_VAR "JAVA_PROFILER_HOME"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief <b>SetLibraryPath</b> Configures the default library path
 *
 * Needed for Bug 317863 to remove dependency on env vars for zOS.
 *
 * The parameter szLibPath should be a path to the location of the Martini libs (the
 * directory containing libJPIBootLoader.so and friends. The effect of this call is:
 *
 * - set szLibPath as the default path from which LoadBistroLibrary tries to load libs
 * - set the environment JAVA_PROFILER_HOME=szLibPath
 *
 * @param szLibPath [in] : Path from which to load libraries
 *
 * @return MRTE_RESULT_OK - Path was configured and environment set
 * @return MRTE_ERROR_LIBRARY_FAILURE - Failure occurred in one of the OS-level calls
 */
TResult SetLibraryPath(const char* szLibPath);

/**
 * @brief <b> GetLibraryPathFromEnv </b> searches for library paths in the process environment
 *
 * Searches for the path from which to load libraries in the following environment variables
 * (in the order they appear):
 * BISTRO_INSTALL_DIR
 * JAVA_PROFILER_HOME
 *
 * @param szLibPath    [out] : path from which to load libraries
 * @param uiLibPathSize [in] : size in bytes of the szLibPath buffer
 * @param uiActualSize [out] : points to the actual size of szLibPath
 *
 * @return MRTE_RESULT_OK - one of the variables was found. szLibPath contains its value
 * @return MRTE_RESULT_FALSE - None of the environment variables were found.
 *                             szLibPath is undefined.
 * @return MRTE_ERROR_ILLEGAL_ARGUMENT - szLibPath is an illegal pointer
 * @return MRTE_ERROR_BUFFER_TOO_SHORT - The buffer pointed by szLibPath is too
 *         short. puiActualSize points to the required buffer size
 */
TResult GetLibraryPathFromEnv(char *szLibPath, 
                              unsigned int uiLibPathSize, 
                              unsigned int *puiActualSize);

Martini::OSA::ILibraryLoader *LoadBistroLibrary(const char* dllName, bool bLoadOnce = false);

TResult PreLoadAgentControllerLibrary(char str_ac_home[]);

#ifdef __cplusplus
} //extern "C" 
#endif

#endif //__RTUTIL_H__

