/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
package org.eclipse.tptp.martini;

public class CGProxy 
{
	private static int m_bJVMInit = 0;
	private static int m_bEventsEnabled = 0;

	public static int IsJVMInit()
	{
		return m_bJVMInit;
	}
	
	public static void JVMInit()
	{
		m_bJVMInit = 1;
	}

	public static void SetEventsStatus(int status)
	{
		m_bEventsEnabled = status;
	}

	public static native void MethodEnter(boolean bIsAlreadyInvoked, int id);
	public static native void MethodLeave(int id);
	public static native void MethodLeaveWithException(int id);

	public static void EarlyMethodEnter(boolean bIsAlreadyInvoked, int id)
	{
		if (m_bEventsEnabled != 0)
		{
			MethodEnter(bIsAlreadyInvoked, id);
		}
	}
	
	public static void EarlyMethodLeave(int id)
	{
		if (m_bEventsEnabled != 0)
		{
			MethodLeave(id);	
		}
	}
	
	public static void EarlyMethodLeaveWithException(int id)
	{
		if (m_bEventsEnabled != 0)
		{
			MethodLeaveWithException(id);
		}
	}

	public static int IsBEAJVM()
	{
		String vendor = System.getProperty("java.vendor");
		if (vendor.startsWith("BEA"))
		{
			return 1;
		}
		return 0;
	}
}
