/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
package org.eclipse.tptp.martini;

public class HeapProxy 
{
	private static int m_bJVMInit = 0;
	private static int m_bEventsEnabled = 0;

	public static int IsJVMInit()
	{
		return m_bJVMInit;
	}
	
	public static void JVMInit()
	{
		m_bJVMInit = 1;
	}
	
	public static void SetEventsStatus(int status)
	{
		m_bEventsEnabled = status;
	}

	public static native void ObjectAlloc(java.lang.Object obj,
	                                      java.lang.Class objClass,
	                                      int methodId,
                                        long loc);

	public static void EarlyObjectAlloc(java.lang.Object obj,
	                                    int methodId,
                                      long loc)
	{
		if (m_bJVMInit != 0 && m_bEventsEnabled != 0)
		{
			ObjectAlloc(obj, obj.getClass(), methodId, loc); 
		}
	}

	public static native void ArrayAlloc(java.lang.Object obj,
	                                     java.lang.Class objClass,
	                                     int methodId,
                                       long loc);

	public static void EarlyArrayAlloc(java.lang.Object obj,
	                                   int methodId,
                                     long loc)
	{
		if (m_bJVMInit != 0 && m_bEventsEnabled != 0)
		{
			ArrayAlloc(obj, obj.getClass(), methodId, loc); 
		}
	}
	
	public static int IsBEAJVM()
	{
		String vendor = System.getProperty("java.vendor");
		if (vendor.startsWith("BEA"))
		{
			return 1;
		}
		return 0;
	}
}
