/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef MRTE_BOOTLOADOPTIONPARSER_H
#define MRTE_BOOTLOADOPTIONPARSER_H

#include "MRTEResults.h"
#include "MList.h"
#include "MString.h"

namespace Martini { namespace Infrastructure
{
    
    /**
     * @struct SModuleSpec
     * Profiler/EC module specifications.
     */
    struct SModuleSpec 
    {
        RTUtil::MCString strName;       //!< library name
        RTUtil::MCString strOptions;    //!< arguments

        SModuleSpec() : strName(), strOptions() {}
        SModuleSpec(const char *szName, const char *szOptions)
            : strName(szName), strOptions(szOptions) {}
    };

    /**
     * @typedef TModuleSpecList
     * Linked list of SModuleSpec items
     */
    typedef RTUtil::MList<SModuleSpec> TModuleSpecList;

    /**
     * @typedef TStringList
     * Linked list of C-style strings
     */
    typedef RTUtil::MList<char*> TStringList;
    
    /**
     * @class CBootLoaderOptionParser
     * Utility class for parsing boot loader options
     */
    class CBootLoaderOptionParser
    {
    public:
        static TResult Parse(SModuleSpec *pECSpec, 
                             TModuleSpecList *pProfilerSpecList,
                             const char *szOptions);
    private:
        CBootLoaderOptionParser();
        virtual ~CBootLoaderOptionParser();

        static void Tokenize(TStringList *pStringList, 
                             const char *szSource,
                             const char *szTokens);
        
        static void FreeStringListItems(TStringList &stringList);
        
        static TResult ParseModuleSpec(SModuleSpec *pSpec, const char *szSpec);


    };
}}

#endif // MRTE_BOOTLOADOPTIONPARSER_H

