/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __JPI_ECAGENT_H__
#define __JPI_ECAGENT_H__

#include "MRTEResults.h"
#include "MPI.h"
#include "MartiniExternalControl.h"
#include "IEventManager.h"
#include "MString.h"

namespace Martini { namespace Infrastructure
{

    //TODO: refactor: CECAgent should not derive from IVmShutdownEventObserver in order 
    //      to handle VM_SHUTDOWN. It should define its own event handler object and use it
    //      instead.
    class CECAgent : public MPI::IVmShutdownEventObserver
    {
    public:
        static CECAgent* GetInstance();
        ~CECAgent();
        TResult Initialize(MPI::TId clientId, 
                           const char* szECName, 
                           Infrastructure::IEventManager *pEventManager,
                           const char *szOptions);
        TResult RegisterEvent(MPI::TEventType event);
        void HandleEvent(MPI::TEventType event, char* szData);
        void NotifyCustomCommandEvent(unsigned int commandId, void *pData);
        void MartiniMessage(char* szMsg, Martini::ExternalControl::ESeverityLevel level);
        void MartiniProcessShutdown();
        void InitializationPhaseCompleted() {}
        
        // IVmShutdownEventObserver methods
        virtual void HandleEvent();
    private:
        CECAgent();

        unsigned int m_vuiRegisteredEvents[(int)ExternalControl::CMD_LAST];
        Infrastructure::IEventManager *m_pEventManager;

        ExternalControl::TRegisterMartiniCallback m_pRegisterMartiniEvent;
        ExternalControl::TMartiniMessage m_pMartiniMessage;
        ExternalControl::TMartiniProcessShutdown m_pMartiniProcessShutdown;
        bool m_bIsECAvailable;
        MPI::TId m_iClient;
        char* m_szConfigData;
    };

}};

#endif // #ifndef __JPI_ECAGENT_H__


