/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __IDATAMANAGER_H__
#define __IDATAMANAGER_H__


namespace Martini { namespace Infrastructure
{
    class IDataManager  
    {
    public:
        virtual TResult GetModuleInfo(MPI::TId clientId,
                                      MPI::TId moduleId,
                                      MPI::BitSet requestedDataTypes, 
                                      MPI::SModuleInfo *pData) = 0;

        virtual TResult GetClassInfo(MPI::TId clientId,
                                     MPI::TId classId,
                                     MPI::BitSet requestedDataTypes, 
                                     MPI::SClassInfo *pData) = 0;

        virtual TResult GetMethodInfo(MPI::TId clientId,
                                      MPI::TId methodId,
                                      MPI::BitSet requestedDataTypes, 
                                      MPI::SMethodInfo *pData) = 0;

        virtual TResult GetObjectInfo(MPI::TId clientId,
                                      MPI::TId objectId,
                                      MPI::BitSet requestedDataTypes,
                                      MPI::SObjectDataRequest *pData) = 0;

        virtual TResult GetThreadInfo(MPI::TId clientId,
                                      MPI::TId threadId,
                                      MPI::BitSet requestedDataTypes, 
                                      MPI::SThreadInfo *pData,
                                      MPI::TDotNetUnmanagedStackWalkCallBack pUnManagedStackWalker) = 0;

        virtual TResult GetCompiledMethodInfo(MPI::TId clientId,
                                              const char* szModuleName,
                                              UIOP uiIpOffset,
                                              MPI::BitSet requestedDataTypes,
                                              MPI::TId *pMethodId,
                                              MPI::SMethodInfo *pData) = 0;
        
        virtual TResult GetAllThreadsInfo(MPI::TId clientId, 
                                          U32 maxFrameCount, 
                                          MPI::BitSet requestedDataTypes, 
                                          MPI::SThreadInfoArray *pData) = 0;

        virtual TResult GetObjectReferences(MPI::TId clientId, 
                                            MPI::SObjectReferenceInfo *pData) = 0;

        virtual bool isHeapObjDataCollectionEnabled() = 0;
        
        virtual void SetHeapObjDataCollection(bool heapObjDataCollection) = 0;
        
        virtual TResult RunHeapObjDataCollection(THeapObjectAnalysis *TId) = 0;

    };

}}

#endif 

