/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __IEVENTMANAGER_H__
#define __IEVENTMANAGER_H__

#include "MpiAPI.h"
#include "MRTEInfrastructureDefinitions.h"

namespace Martini { namespace Infrastructure
{
    class IEventManager  
    {
    public:
		
        virtual TResult RegisterEvent(MPI::TId clientId,
                                      MPI::IEventObserver &observer) = 0;
        
        virtual TResult SetEventGroupFilter(MPI::TId clientID, 
                                            MPI::EEventGroup group,
                                            MPI::IEventFilter &filter) = 0;


        virtual TResult EnableEventGroup(MPI::TId clientId, 
                                         MPI::EEventGroup eventGroup) = 0;

        virtual TResult DisableEventGroup(MPI::TId clientId, 
                                          MPI::EEventGroup eventGroup) = 0;
      

        virtual void SetEventImplementor(MPI::TEventType mpiEvent, 
                                         EEventImplementationType implementor) = 0;

        virtual void NotifyECEvent(MPI::TEventType event, 
                                   char *szData,
                                   unsigned int commandId,
                                   void *pData) = 0;
    };

}}

#endif 

